//
// property.cpp
//
// Property code.
//

#include "globals.h"
#include "mark.h"
#include "editsess.h"
#include "pstore.h"
#include <wchar.h>
#include <commctrl.h>
#include "FolderUtil.h"
#include "AkkharaActivateEvent.h"
#include "AkkharaDeactivateEvent.h"
#include "AkkharaWindowCommandEvent.h"


const TCHAR c_szWorkerWndClass[] = TEXT("Mark Worker Wnd Class");


//+---------------------------------------------------------------------------
//
// _InitWorkerWnd
//
// Called from Activate.  Create a worker window to receive private windows
// messages.
//----------------------------------------------------------------------------

BOOL CMarkTextService::_InitWorkerWnd()
{
	BOOL bStat;
	bStat = CreateWorkerWnd();
    bStat = bStat && wndInputText->Create(this, _WorkerWndProc, g_hInst, _hWorkerWnd);
	bStat = bStat && this->InvokeEvent(
		std::shared_ptr<Event::Event>(new Event::AkkharaActivateEvent()),
		std::shared_ptr<Event::Message>(new Event::AkkharaActivateMessage(this, _WorkerWndProc, g_hInst))
	);

    return bStat;
}

//+---------------------------------------------------------------------------
//
// _UninitWorkerWnd
//
// Called from Deactivate.  Destroy the worker window.
//----------------------------------------------------------------------------

void CMarkTextService::_UninitWorkerWnd()
{
	DestroyWorkerWnd();
	wndInputText->Destroy();
	this->InvokeEvent(
		std::shared_ptr<Event::Event>(new Event::AkkharaDeactivateEvent()),
		std::shared_ptr<Event::Message>(new Event::AkkharaDeactivateMessage())
	);
}

//+---------------------------------------------------------------------------
//
// _WorkerWndProc
//
//----------------------------------------------------------------------------

/* static */
LRESULT CALLBACK CMarkTextService::_WorkerWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    CMarkTextService *_this;
	TCHAR buf[256];

    switch (uMsg)
    {
        case WM_CREATE:
			// save the this pointer we originally passed into CreateWindow
            SetWindowLongPtr(hWnd, GWLP_USERDATA, 
                             (LONG_PTR)((CREATESTRUCT *)lParam)->lpCreateParams);
            return 0;
		case WM_COMMAND:
		case WM_NOTIFY:
			GetClassName(hWnd, buf, 255);
			_this = (CMarkTextService*)GetWindowLongPtr(hWnd, GWLP_USERDATA);
			_this->InvokeEvent(
				std::shared_ptr<Event::AkkharaWindowCommandEvent>(new Event::AkkharaWindowCommandEvent()),
				std::shared_ptr<Event::AkkharaWindowCommandMessage>(new Event::AkkharaWindowCommandMessage(uMsg, wParam, _this->Compositor()))
			);
			break;
		default:
			break;
	}

    return DefWindowProc(hWnd, uMsg, wParam, lParam);
}

//+---------------------------------------------------------------------------
//
// CreateWorkerWnd
//
// Called from Activate.  Create a worker window to receive private windows
// messages.
//----------------------------------------------------------------------------

BOOL CMarkTextService::CreateWorkerWnd()
{
	WNDCLASS wc;

	memset(&wc, 0, sizeof(wc));
	wc.lpfnWndProc = _WorkerWndProc;
	wc.hInstance = g_hInst;
	wc.lpszClassName = c_szWorkerWndClass;

	if (RegisterClass(&wc) == 0)
		return FALSE;

//	_hWorkerWnd = CreateWindow(c_szWorkerWndClass, TEXT("Mark Worker Wnd"),
//		0, CW_USEDEFAULT, CW_USEDEFAULT, 200, 20, NULL, NULL, g_hInst, this);
	_hWorkerWnd = CreateWindow(c_szWorkerWndClass, TEXT("Mark Worker Wnd"),
		0, 0, 0, 0, 0, NULL, NULL, g_hInst, this);

	return (_hWorkerWnd != NULL);
}

//+---------------------------------------------------------------------------
//
// DestroyWorkerWnd
//
// Called from Deactivate.  Destroy the worker window.
//----------------------------------------------------------------------------

void CMarkTextService::DestroyWorkerWnd()
{
	if (_hWorkerWnd != NULL)
	{
		DestroyWindow(_hWorkerWnd);
		_hWorkerWnd = NULL;
	}
	UnregisterClass(c_szWorkerWndClass, g_hInst);
}
