//
// mark.h
//
// CMarkTextService declaration.
//

#ifndef MARK_H
#define MARK_H
#include <vector>
#include <memory>
#include "globals.h"
#include "WindowInputText.h"
#include "WindowConversionRule.h"
#include "WindowSoftwareInformation.h"
#include "KeyboardManager.h"
#include "Compositor.h"
#include <unordered_map>
#include "Observer.h"
#include "AkkharaMenuSelectEvent.h"
#include "langbar.h"
#include "CursorManager.h"


class CMarkTextService : public ITfTextInputProcessorEx,
                         public ITfDisplayAttributeProvider,
                         public ITfCreatePropertyStore,
                         public ITfThreadMgrEventSink,
                         public ITfTextEditSink,
                         public ITfCompositionSink,
                         public ITfCleanupContextDurationSink,
                         public ITfCleanupContextSink,
                         public ITfCompartmentEventSink,
                         public ITfKeyEventSink,
                         public ITfTextLayoutSink,
                         public Observer::Subject
{
public:
    CMarkTextService();
    ~CMarkTextService();

    // IUnknown
    STDMETHODIMP QueryInterface(REFIID riid, void **ppvObj);
    STDMETHODIMP_(ULONG) AddRef(void);
    STDMETHODIMP_(ULONG) Release(void);

    // ITfTextInputProcessorEx
    STDMETHODIMP Activate(ITfThreadMgr *pThreadMgr, TfClientId tfClientId);
    STDMETHODIMP Deactivate();
    STDMETHODIMP ActivateEx(ITfThreadMgr *pThreadMgr, TfClientId tfClientId, DWORD dwFlags);

    // ITfDisplayAttributeProvider
    STDMETHODIMP EnumDisplayAttributeInfo(IEnumTfDisplayAttributeInfo **ppEnum);
    STDMETHODIMP GetDisplayAttributeInfo(REFGUID guidInfo, ITfDisplayAttributeInfo **ppInfo);

    // ITfCreatePropertyStore
    STDMETHODIMP IsStoreSerializable(REFGUID guidProperty, ITfRange *pRange, ITfPropertyStore *pPropertyStore, BOOL *pfSerializable);
    STDMETHODIMP CreatePropertyStore(REFGUID guidProperty, ITfRange *pRange, ULONG cb, IStream *pStream, ITfPropertyStore **ppStore);

    // ITfThreadMgrEventSink
    STDMETHODIMP OnInitDocumentMgr(ITfDocumentMgr *pDocMgr);
    STDMETHODIMP OnUninitDocumentMgr(ITfDocumentMgr *pDocMgr);
    STDMETHODIMP OnSetFocus(ITfDocumentMgr *pDocMgrFocus, ITfDocumentMgr *pDocMgrPrevFocus);
    STDMETHODIMP OnPushContext(ITfContext *pContext);
    STDMETHODIMP OnPopContext(ITfContext *pContext);

    // ITfTextEditSink
    STDMETHODIMP OnEndEdit(ITfContext *pContext, TfEditCookie ecReadOnly, ITfEditRecord *pEditRecord);

    // ITfCompositionSink
    STDMETHODIMP OnCompositionTerminated(TfEditCookie ecWrite, ITfComposition *pComposition);

    // ITfCleanupContextDurationSink
    STDMETHODIMP OnStartCleanupContext();
    STDMETHODIMP OnEndCleanupContext();

    // ITfCleanupContextSink
    STDMETHODIMP OnCleanupContext(TfEditCookie ecWrite, ITfContext *pContext);

    // ITfCompartmentEventSink
    STDMETHODIMP OnChange(REFGUID rguidCompartment);

    // ITfKeyEventSink
    STDMETHODIMP OnSetFocus(BOOL fForeground);
    STDMETHODIMP OnTestKeyDown(ITfContext *pContext, WPARAM wParam, LPARAM lParam, BOOL *pfEaten);
    STDMETHODIMP OnKeyDown(ITfContext *pContext, WPARAM wParam, LPARAM lParam, BOOL *pfEaten);
    STDMETHODIMP OnTestKeyUp(ITfContext *pContext, WPARAM wParam, LPARAM lParam, BOOL *pfEaten);
    STDMETHODIMP OnKeyUp(ITfContext *pContext, WPARAM wParam, LPARAM lParam, BOOL *pfEaten);
    STDMETHODIMP OnPreservedKey(ITfContext *pContext, REFGUID rguid, BOOL *pfEaten);

    // ITfTextLayoutSink
    STDMETHODIMP OnLayoutChange(ITfContext* pContext, TfLayoutCode layoutCode, ITfContextView* pContextView);

    // CClassFactory factory callback
    static HRESULT CreateInstance(IUnknown *pUnkOuter, REFIID riid, void **ppvObj);

    // server registration
    static BOOL RegisterProfiles();
    static void UnregisterProfiles();
    static BOOL RegisterCategories(BOOL fRegister);
    static BOOL RegisterServer();
    static void UnregisterServer();

    void SetComposition(ITfContext *pContext);
    Composition::Compositor* Compositor() {
        return &compositor_;
    }

    virtual void AddObserver(std::shared_ptr<Event::Event> event, std::shared_ptr<Observer::Observer> observer) {
        observers_[event->GetName()].push_back(observer);
    }

    virtual bool InvokeEvent(std::shared_ptr<Event::Event> event, std::shared_ptr<Event::Message> message) {
        bool result = true;
        for (auto observer : observers_[event->GetName()]) {
            result = result && observer->Notify(message);
        }
        return result;
    }

    // keystroke handlers
    HRESULT _HandleKeyDownConvert(TfEditCookie ec, ITfContext *pContext, WPARAM wParam, BOOL with_shift);
	HRESULT _FinishInput(TfEditCookie ec, ITfContext *pContext);
	HRESULT _HandleBack(TfEditCookie ec, ITfContext *pContext);
	HRESULT _HandleNormalization(TfEditCookie ec, ITfContext *pContext);
	HRESULT _HandleAsciiInput(TfEditCookie ec, ITfContext *pContext);
	HRESULT _HandleSpace(TfEditCookie ec, ITfContext *pContext);
	HRESULT _HandleRetry(TfEditCookie ec, ITfContext *pContext, ITfContextView *pContextView);
		
	// Cvbg[hċN
	void RestartInput(ITfContext *pContext);

	// ʃEChE̕NA
	void WorkerWindowClear(TfEditCookie ec, ITfContext *pContext);

	// callbacks for CCompositionEditSession
    BOOL _IsComposing()
    {
        return _pComposition != NULL;
    }
    ITfComposition *_GetComposition()
    {
		return _pComposition;
    }
    void _SetComposition(ITfComposition *pComposition)
    {
        _pComposition = pComposition;
        _pComposition->AddRef();
	}
    void _TerminateComposition(TfEditCookie ec)
    {
        if (_pComposition != NULL)
        {
            _ClearCompositionDisplayAttributes(ec);
            _pComposition->EndComposition(ec);
            SafeReleaseClear(_pComposition);
        }
    }
    void _TerminateCompositionInContext(ITfContext *pContext);
    void _ClearCompositionDisplayAttributes(TfEditCookie ec);
    BOOL _SetCompositionDisplayAttributes(TfEditCookie ec);

	HINSTANCE		_hInstance;
	HWND			_hWnd;

    BOOL IsInvalidComposition(ITfContext* pContext, TfEditCookie ec);

private:
    // init methods
    BOOL _InitLanguageBar();
    BOOL _InitThreadMgrSink();
    BOOL _InitTextEditSink(ITfDocumentMgr *pDocMgr);
    BOOL _InitDisplayAttributeGuidAtom();
    BOOL _InitCleanupContextDurationSink();
    BOOL _InitCleanupContextSink(ITfContext *pContext);
    BOOL _InitContextCompartment(ITfContext *pContext);
    BOOL _InitGlobalCompartment();
    BOOL _InitWorkerWnd();
    BOOL _InitKeystrokeSink();
    BOOL _InitLayoutSink(ITfDocumentMgr *pDocMgr);

    // uninit methods
    void _UninitLanguageBar();
    void _UninitThreadMgrSink();
    void _UninitCleanupContextDurationSink();
    void _UninitCleanupContextSink(ITfContext *pContext);
    void _UninitCompartment(ITfContext *pContext);
    void _UninitGlobalCompartment();
    void _UninitWorkerWnd();
    void _UninitKeystrokeSink();

    static LRESULT CALLBACK _WorkerWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

    //
    // state
    //

    ITfThreadMgr *_pThreadMgr;
    TfClientId _tfClientId;
    
    ITfComposition *_pComposition; // pointer to an ongoing composition, or NULL if there is none

    BOOL _fCleaningUp;

    TfGuidAtom _gaDisplayAttribute;

    CLangBarItemButton *_pLangBarItem;

    DWORD _dwThreadMgrEventSinkCookie;
    DWORD _dwThreadFocusSinkCookie;
    DWORD _dwTextEditSinkCookie;
    DWORD _dwGlobalCompartmentEventSinkCookie;
    DWORD _dwTextLayoutSinkCookie;

    ITfContext *_pTextEditSinkContext;
    ITfContext* _pTextLayoutSinkContext;

	HWND _hWorkerWnd;

    LONG _cRef;     // COM ref count

	BOOL CreateWorkerWnd();
	void DestroyWorkerWnd();

	std::shared_ptr<GUI::CWindowInputTextCommon> wndInputText;
    TSF::CursorManager cursorManager_;

    std::shared_ptr<KeyboardUtils::KeyboardManager> keyboadManager_;

    BOOL DeterminEat(WPARAM wParam, ITfContext* pContext);
    BOOL IsArrowKey(WPARAM wParam);
    static BOOL WithShift();

    Composition::Compositor compositor_;
    std::unordered_map<std::string, std::vector<std::shared_ptr<Observer::Observer>>> observers_;
};


#endif // MARK_H
