//
// mark.cpp
//
// IUnknown, ITfTextInputProcessor implementation.
//

#include "globals.h"
#include "mark.h"
#include "uwp_util.h"
#include "ConversionRuleWindowObserver.h"
#include "SoftInfoWindowObserver.h"

#pragma comment(lib, "winmm.lib")
//+---------------------------------------------------------------------------
//
// CreateInstance
//
//----------------------------------------------------------------------------

CMarkTextService* pMarkService = NULL;

/* static */
HRESULT CMarkTextService::CreateInstance(IUnknown *pUnkOuter, REFIID riid, void **ppvObj)
{
    HRESULT hr;

    if (ppvObj == NULL)
        return E_INVALIDARG;

    *ppvObj = NULL;

    if (NULL != pUnkOuter)
        return CLASS_E_NOAGGREGATION;

    
    // Windows 8.1(炭)CUASɂĂKeyDown̂тCreateInstances邽ߎg܂킷B
    if (pMarkService == NULL) {
		try {
			pMarkService = new CMarkTextService();
		}
		catch (...) {
			// mۂɎsĂAvŜȂ悤ɂĂ
			LogOutput(__FUNCTION__, __LINE__, "unknown exception");
			return E_UNEXPECTED;
		}

		if (pMarkService == NULL) {
			LogOutput(__FUNCTION__, __LINE__, "out of memory");
			return E_OUTOFMEMORY;
		}


		Observer::ConversionRuleWindowRegisterer crw;
		crw.Register(pMarkService);
		Observer::SoftInfoWindowRegisterer si;
		si.Register(pMarkService);
    }

    hr = pMarkService->QueryInterface(riid, ppvObj);

    return hr;
}

//+---------------------------------------------------------------------------
//
// ctor
//
//----------------------------------------------------------------------------

CMarkTextService::CMarkTextService() 
    : keyboadManager_(new KeyboardUtils::UsKeyboardManager())
{
    DllAddRef();

    if (is_uwp()) {
        wndInputText = std::make_shared<GUI::CWindowInputTextUWP>();
    }
    else {
        wndInputText = std::make_shared<GUI::CWindowInputTextNative>();
    }

    _pThreadMgr = NULL;
    _tfClientId = TF_CLIENTID_NULL;

    _pComposition = NULL;

    _fCleaningUp = FALSE;

    _gaDisplayAttribute = TF_INVALID_GUIDATOM;

    _pLangBarItem = NULL;

    _dwThreadMgrEventSinkCookie = TF_INVALID_COOKIE;
    _dwThreadFocusSinkCookie = TF_INVALID_COOKIE;
    _dwTextEditSinkCookie = TF_INVALID_COOKIE;
    _dwGlobalCompartmentEventSinkCookie = TF_INVALID_COOKIE;
    _dwTextLayoutSinkCookie = TF_INVALID_COOKIE;

    _pTextEditSinkContext = NULL;
    _pTextLayoutSinkContext = NULL;

	_hWorkerWnd = NULL;

    _cRef = 1;
}

//+---------------------------------------------------------------------------
//
// dtor
//
//----------------------------------------------------------------------------

CMarkTextService::~CMarkTextService()
{
    DllRelease();
}

//+---------------------------------------------------------------------------
//
// QueryInterface
//
//----------------------------------------------------------------------------

STDAPI CMarkTextService::QueryInterface(REFIID riid, void **ppvObj)
{
    if (ppvObj == NULL)
        return E_INVALIDARG;

    *ppvObj = NULL;

    if (IsEqualIID(riid, IID_ITfTextInputProcessorEx)) {
        *ppvObj = (ITfTextInputProcessorEx *)this;
    }
    if (IsEqualIID(riid, IID_IUnknown) ||
        IsEqualIID(riid, IID_ITfTextInputProcessor))
    {
        *ppvObj = (ITfTextInputProcessor *)this;
    }
    else if (IsEqualIID(riid, IID_ITfDisplayAttributeProvider))
    {
        *ppvObj = (ITfDisplayAttributeProvider *)this;
    }
    else if (IsEqualIID(riid, IID_ITfCreatePropertyStore))
    {
        *ppvObj = (ITfCreatePropertyStore *)this;
    }
    else if (IsEqualIID(riid, IID_ITfThreadMgrEventSink))
    {
        *ppvObj = (ITfThreadMgrEventSink *)this;
    }
    else if (IsEqualIID(riid, IID_ITfTextEditSink))
    {
        *ppvObj = (ITfTextEditSink *)this;
    }
    else if (IsEqualIID(riid, IID_ITfCleanupContextSink))
    {
        *ppvObj = (ITfCleanupContextSink *)this;
    }
    else if (IsEqualIID(riid, IID_ITfCleanupContextDurationSink))
    {
        *ppvObj = (ITfCleanupContextDurationSink *)this;
    }
    else if (IsEqualIID(riid, IID_ITfCompartmentEventSink))
    {
        *ppvObj = (ITfCompartmentEventSink *)this;
    }
    else if (IsEqualIID(riid, IID_ITfTextLayoutSink))
    {
        *ppvObj = (ITfTextLayoutSink *)this;
    }

    if (*ppvObj)
    {
        AddRef();
        return S_OK;
    }

    return E_NOINTERFACE;
}


//+---------------------------------------------------------------------------
//
// AddRef
//
//----------------------------------------------------------------------------

STDAPI_(ULONG) CMarkTextService::AddRef()
{
    return ++_cRef;
}

//+---------------------------------------------------------------------------
//
// Release
//
//----------------------------------------------------------------------------

STDAPI_(ULONG) CMarkTextService::Release()
{
    LONG cr = --_cRef;

    assert(_cRef >= 0);

    if (_cRef == 0)
    {
        delete this;
    }

    return cr;
}

//+---------------------------------------------------------------------------
//
// Activate
//
//----------------------------------------------------------------------------

STDAPI CMarkTextService::Activate(ITfThreadMgr *pThreadMgr, TfClientId tfClientId)
{
	LogOutput(__FUNCTION__, __LINE__, "Activate");
	_pThreadMgr = pThreadMgr;
    _pThreadMgr->AddRef();

    _tfClientId = tfClientId;

    if (!_InitLanguageBar())
        goto ExitError;

    if (!_InitThreadMgrSink())
        goto ExitError;

    if (!_InitDisplayAttributeGuidAtom())
        goto ExitError;

    if (!_InitCleanupContextDurationSink())
        goto ExitError;

    if (!_InitGlobalCompartment())
        goto ExitError;

    if (!_InitWorkerWnd())
        goto ExitError;

    if (!_InitKeystrokeSink())
        goto ExitError;

	return S_OK;

ExitError:
    Deactivate(); // cleanup any half-finished init
    return E_FAIL;
}

STDMETHODIMP CMarkTextService::ActivateEx(ITfThreadMgr* pThreadMgr, TfClientId tfClientId, DWORD dwFlags) {
	// LogOutput(__FUNCTION__, __LINE__, "dwFlags=%d", dwFlags);
    return Activate(pThreadMgr, tfClientId);
}

//+---------------------------------------------------------------------------
//
// Deactivate
//
//----------------------------------------------------------------------------

STDAPI CMarkTextService::Deactivate()
{
    // Windows 10̃^XNo[ɂCortanaɓ͂ہAIME؂ւDeactivate2xĂԂƂB
    // ̎xdeactivateƗ邽߁AoĉB
    if (_tfClientId == TF_CLIENTID_NULL) {
	    LogOutput(__FUNCTION__, __LINE__, "Double Deactivate detected");
        return E_FAIL;
    }
	LogOutput(__FUNCTION__, __LINE__, "Deactivate");
	_UninitThreadMgrSink();
    _UninitLanguageBar();
    _UninitCleanupContextDurationSink();
    _UninitGlobalCompartment();
    _UninitWorkerWnd();
    _UninitKeystrokeSink();
    _InitTextEditSink(NULL);
    _InitLayoutSink(NULL);

    // we MUST release all refs to _pThreadMgr in Deactivate
    SafeReleaseClear(_pThreadMgr);

    _tfClientId = TF_CLIENTID_NULL;

    return S_OK;
}
