//
// langbar.cpp
//
// Language bar ui code.
//

#include "globals.h"
#include "mark.h"
#include "resource.h"
#include "langbar.h"
#include "AkkharaMenuInitEvent.h"

#define MARK_LANGBARITEMSINK_COOKIE 0x0fab0fab

const WCHAR *c_rgMenuItems[] =
{
	L"Select Language"
};

//+---------------------------------------------------------------------------
//
// ctor
//
//----------------------------------------------------------------------------

CLangBarItemButton::CLangBarItemButton(CMarkTextService *pMark)
{
    DllAddRef();

    _tfLangBarItemInfo.clsidService = c_clsidMarkTextService;
    _tfLangBarItemInfo.guidItem = c_guidLangBarItemButton;
	_tfLangBarItemInfo.dwStyle = TF_LBI_STYLE_BTN_MENU;
//	_tfLangBarItemInfo.dwStyle = TF_LBI_STYLE_BTN_BUTTON;
//	_tfLangBarItemInfo.dwStyle = TF_LBI_STYLE_BTN_TOGGLE;
	_tfLangBarItemInfo.ulSort = 0;
    wcscpy_s(_tfLangBarItemInfo.szDescription, ARRAYSIZE(_tfLangBarItemInfo.szDescription), LANGBAR_ITEM_DESC);

    _pMark = pMark;
    _pMark->AddRef();
    _pLangBarItemSink = NULL;

    _cRef = 1;

	m_nCurSelected = 0;
}

//+---------------------------------------------------------------------------
//
// dtor
//
//----------------------------------------------------------------------------

CLangBarItemButton::~CLangBarItemButton()
{
    DllRelease();
    _pMark->Release();
}

//+---------------------------------------------------------------------------
//
// QueryInterface
//
//----------------------------------------------------------------------------

STDAPI CLangBarItemButton::QueryInterface(REFIID riid, void **ppvObj)
{
    if (ppvObj == NULL)
        return E_INVALIDARG;

    *ppvObj = NULL;

    if (IsEqualIID(riid, IID_IUnknown) ||
        IsEqualIID(riid, IID_ITfLangBarItem) ||
        IsEqualIID(riid, IID_ITfLangBarItemButton))
    {
        *ppvObj = (ITfLangBarItemButton *)this;
    }
    else if (IsEqualIID(riid, IID_ITfSource))
    {
        *ppvObj = (ITfSource *)this;
    }

    if (*ppvObj)
    {
        AddRef();
        return S_OK;
    }

    return E_NOINTERFACE;
}


//+---------------------------------------------------------------------------
//
// AddRef
//
//----------------------------------------------------------------------------

STDAPI_(ULONG) CLangBarItemButton::AddRef()
{
    return ++_cRef;
}

//+---------------------------------------------------------------------------
//
// Release
//
//----------------------------------------------------------------------------

STDAPI_(ULONG) CLangBarItemButton::Release()
{
    LONG cr = --_cRef;

    assert(_cRef >= 0);

    if (_cRef == 0)
    {
        delete this;
    }

    return cr;
}

//+---------------------------------------------------------------------------
//
// GetInfo
//
//----------------------------------------------------------------------------

STDAPI CLangBarItemButton::GetInfo(TF_LANGBARITEMINFO *pInfo)
{
    *pInfo = _tfLangBarItemInfo;
    return S_OK;
}

//+---------------------------------------------------------------------------
//
// GetStatus
//
//----------------------------------------------------------------------------

STDAPI CLangBarItemButton::GetStatus(DWORD *pdwStatus)
{
    *pdwStatus = 0;
    return S_OK;
}

//+---------------------------------------------------------------------------
//
// Show
//
//----------------------------------------------------------------------------

STDAPI CLangBarItemButton::Show(BOOL fShow)
{
    return E_NOTIMPL;
}

//+---------------------------------------------------------------------------
//
// GetTooltipString
//
//----------------------------------------------------------------------------

STDAPI CLangBarItemButton::GetTooltipString(BSTR *pbstrToolTip)
{
    *pbstrToolTip = SysAllocString(LANGBAR_ITEM_DESC);

    return (*pbstrToolTip == NULL) ? E_OUTOFMEMORY : S_OK;
}

//+---------------------------------------------------------------------------
//
// OnClick
//
//----------------------------------------------------------------------------

STDAPI CLangBarItemButton::OnClick(TfLBIClick click, POINT pt, const RECT *prcArea)
{
	return S_OK;
}

//+---------------------------------------------------------------------------
//
// InitMenu
//
//----------------------------------------------------------------------------

STDAPI CLangBarItemButton::InitMenu(ITfMenu *pMenu)
{
	ITfMenu *pSubMenu = NULL;

	// Select Language
	pMenu->AddMenuItem(0, TF_LBMENUF_SUBMENU, NULL, NULL, c_rgMenuItems[0], (ULONG)wcslen(c_rgMenuItems[0]), &pSubMenu);
    auto languages = _pMark->Compositor()->Languages();
	// ꃊXgTuj[ɒǉ
    for (auto language: languages) {
        auto i = language.ID();
        auto name = language.Name();
        
		// ݑIĂ鍀ڂɃ`FbN}[Nt
		if (i == m_nCurSelected) {
			pSubMenu->AddMenuItem(i, TF_LBMENUF_CHECKED, NULL, NULL, name.c_str(), (ULONG)wcslen(name.c_str()), NULL);
		}
		else {
			pSubMenu->AddMenuItem(i, 0, NULL, NULL, name.c_str(), (ULONG)wcslen(name.c_str()), NULL);
		}
	}
	pSubMenu->Release();

	// ϊe[u̐
    _pMark->Compositor()->Switch(m_nCurSelected);

    // {^o^Cxg𔭐B
    std::vector<std::pair<std::size_t, std::wstring>> titles;
    std::size_t id = languages.size();
	_pMark->InvokeEvent(
		std::shared_ptr<Event::AkkharaMenuInitEvent>(new Event::AkkharaMenuInitEvent()),
		std::shared_ptr<Event::AkkharaMenuInitMessage>(new Event::AkkharaMenuInitMessage(
            [&id, &titles, &pMenu](std::wstring title) {
				// callbackɂ{^̃^CĝłɊÂăj[o^B
				// Ăяoɂ̓{^IDԂB
                id++;
	            pMenu->AddMenuItem(id, 0, NULL, NULL, title.c_str(), title.size(), NULL);
                return id;
            }
        ))
	);

	LogOutput(__FUNCTION__, __LINE__, "m_nCurSelected [%d]", m_nCurSelected);

	return S_OK;
}

//+---------------------------------------------------------------------------
//
// OnMenuSelect
//
//----------------------------------------------------------------------------

STDAPI CLangBarItemButton::OnMenuSelect(UINT wID)
{
	// Select Language
    auto languages = _pMark->Compositor()->Languages();
	if (wID < languages.size()) {
		m_nCurSelected = wID;
        _pMark->Compositor()->Switch(m_nCurSelected);
    }
    else {
        _pMark->InvokeEvent(
            std::shared_ptr<Event::AkkharaMenuSelectEvent>(new Event::AkkharaMenuSelectEvent()),
            std::shared_ptr<Event::AkkharaMenuSelectMessage>(new Event::AkkharaMenuSelectMessage(wID, _pMark->Compositor()))
        );
    }

    return S_OK;
}

//+---------------------------------------------------------------------------
//
// GetIcon
//
//----------------------------------------------------------------------------

STDAPI CLangBarItemButton::GetIcon(HICON *phIcon)
{
    *phIcon = (HICON)LoadImage(g_hInst, TEXT("IDI_MARK"), IMAGE_ICON, 16, 16, 0);

    return (*phIcon != NULL) ? S_OK : E_FAIL;
}

//+---------------------------------------------------------------------------
//
// GetText
//
//----------------------------------------------------------------------------

STDAPI CLangBarItemButton::GetText(BSTR *pbstrText)
{
    *pbstrText = SysAllocString(LANGBAR_ITEM_DESC);

    return (*pbstrText == NULL) ? E_OUTOFMEMORY : S_OK;
}

//+---------------------------------------------------------------------------
//
// AdviseSink
//
//----------------------------------------------------------------------------

STDAPI CLangBarItemButton::AdviseSink(REFIID riid, IUnknown *punk, DWORD *pdwCookie)
{
    if (!IsEqualIID(IID_ITfLangBarItemSink, riid))
        return CONNECT_E_CANNOTCONNECT;

    if (_pLangBarItemSink != NULL)
        return CONNECT_E_ADVISELIMIT;

    if (punk->QueryInterface(IID_ITfLangBarItemSink, (void **)&_pLangBarItemSink) != S_OK)
    {
        _pLangBarItemSink = NULL;
        return E_NOINTERFACE;
    }

    *pdwCookie = MARK_LANGBARITEMSINK_COOKIE;
    return S_OK;
}

//+---------------------------------------------------------------------------
//
// UnadviseSink
//
//----------------------------------------------------------------------------

STDAPI CLangBarItemButton::UnadviseSink(DWORD dwCookie)
{
    if (dwCookie != MARK_LANGBARITEMSINK_COOKIE)
        return CONNECT_E_NOCONNECTION;

    if (_pLangBarItemSink == NULL)
        return CONNECT_E_NOCONNECTION;

    _pLangBarItemSink->Release();
    _pLangBarItemSink = NULL;

    return S_OK;
}

//+---------------------------------------------------------------------------
//
// _InitLanguageBar
//
//----------------------------------------------------------------------------

BOOL CMarkTextService::_InitLanguageBar()
{
    ITfLangBarItemMgr *pLangBarItemMgr;
    BOOL fRet;

    if (_pThreadMgr->QueryInterface(IID_ITfLangBarItemMgr, (void **)&pLangBarItemMgr) != S_OK)
        return FALSE;

    fRet = FALSE;

    if ((_pLangBarItem = new CLangBarItemButton(this)) == NULL)
        goto Exit;

    if (pLangBarItemMgr->AddItem(_pLangBarItem) != S_OK)
    {
        _pLangBarItem->Release();
        _pLangBarItem = NULL;
        goto Exit;
    }

    fRet = TRUE;
Exit:
    pLangBarItemMgr->Release();
    return fRet;
}

//+---------------------------------------------------------------------------
//
// _UninitLanguageBar
//
//----------------------------------------------------------------------------

void CMarkTextService::_UninitLanguageBar()
{
    ITfLangBarItemMgr *pLangBarItemMgr;

    if (_pLangBarItem == NULL)
        return;

    if (_pThreadMgr->QueryInterface(IID_ITfLangBarItemMgr, (void **)&pLangBarItemMgr) == S_OK)
    {
        pLangBarItemMgr->RemoveItem(_pLangBarItem);
        pLangBarItemMgr->Release();
    }

    _pLangBarItem->Release();
    _pLangBarItem = NULL;
}
