//
// globals.cpp
//
// Global variables.
//

#include "globals.h"

HINSTANCE g_hInst;

LONG g_cRefDll = -1; // -1 /w no refs, for win95 InterlockedIncrement/Decrement compat

CRITICAL_SECTION g_cs;

// 840C3A54-382D-4E11-9B61-0A4B0F3064AB
const CLSID c_clsidMarkTextService = { 0x840c3a54, 0x382d, 0x4e11, { 0x9b, 0x61, 0xa, 0x4b, 0xf, 0x30, 0x64, 0xab } };

// E988EDBA-375D-4885-8A14-4E371CD9844C
const GUID c_guidMarkProfile = { 0xe988edba, 0x375d, 0x4885, { 0x8a, 0x14, 0x4e, 0x37, 0x1c, 0xd9, 0x84, 0x4c } };

// 3B249C5D-ADAB-4C81-888B-FB2769883E07
const GUID c_guidLangBarItemButton = { 0x3b249c5d, 0xadab, 0x4c81, { 0x88, 0x8b, 0xfb, 0x27, 0x69, 0x88, 0x3e, 0x7 } };

// F841BA89-1CDC-4BD0-B35E-2182E4BC930C
const GUID c_guidMarkDisplayAttribute = { 0xf841ba89, 0x1cdc, 0x4bd0, { 0xb3, 0x5e, 0x21, 0x82, 0xe4, 0xbc, 0x93, 0xc } };

// BB63D4A8-53DE-454D-8BFE-4C43236DE3B0
const GUID c_guidMarkContextCompartment = { 0xbb63d4a8, 0x53de, 0x454d, { 0x8b, 0xfe, 0x4c, 0x43, 0x23, 0x6d, 0xe3, 0xb0 } };

// E40A5FE8-A6B1-4553-B9C8-7CCC4EF0C08A
const GUID c_guidMarkGlobalCompartment = { 0xe40a5fe8, 0xa6b1, 0x4553, { 0xb9, 0xc8, 0x7c, 0xcc, 0x4e, 0xf0, 0xc0, 0x8a } };

// 66EC6D3C-D45B-47E8-96EF-434EA3D3EB86
const GUID c_guidCaseProperty = { 0x66ec6d3c, 0xd45b, 0x47e8, { 0x96, 0xef, 0x43, 0x4e, 0xa3, 0xd3, 0xeb, 0x86 } };

// FF2C0474-B9C5-442A-9585-8CDCD14A564D
const GUID c_guidCustomProperty = { 0xff2c0474, 0xb9c5, 0x442a, { 0x95, 0x85, 0x8c, 0xdc, 0xd1, 0x4a, 0x56, 0x4d } };

//+---------------------------------------------------------------------------
//
// AdviseSink
//
//----------------------------------------------------------------------------

BOOL AdviseSink(IUnknown *pSourceIn, IUnknown *pSink, REFIID riid, DWORD *pdwCookie)
{
    ITfSource *pSource;
    HRESULT hr;

    if (pSourceIn->QueryInterface(IID_ITfSource, (void **)&pSource) != S_OK)
        return FALSE;

    hr = pSource->AdviseSink(riid, pSink, pdwCookie);

    pSource->Release();

    if (hr != S_OK)
    {
        // make sure we don't try to Unadvise pdwCookie later
        *pdwCookie = TF_INVALID_COOKIE;
        return FALSE;
    }

    return TRUE;
}

//+---------------------------------------------------------------------------
//
// UnadviseSink
//
//----------------------------------------------------------------------------

void UnadviseSink(IUnknown *pSourceIn, DWORD *pdwCookie)
{
    ITfSource *pSource;

    if (*pdwCookie == TF_INVALID_COOKIE)
        return; // never Advised

    if (pSourceIn->QueryInterface(IID_ITfSource, (void **)&pSource) == S_OK)
    {
        pSource->UnadviseSink(*pdwCookie);
        pSource->Release();
    }

    *pdwCookie = TF_INVALID_COOKIE;
}

//+---------------------------------------------------------------------------
//
// AdviseSingleSink
//
//----------------------------------------------------------------------------

BOOL AdviseSingleSink(TfClientId tfClientId, IUnknown *pSourceIn, IUnknown *pSink, REFIID riid)
{
    ITfSourceSingle *pSource;
    HRESULT hr;

    if (pSourceIn->QueryInterface(IID_ITfSourceSingle, (void **)&pSource) != S_OK)
        return FALSE;

    hr = pSource->AdviseSingleSink(tfClientId, riid, pSink);

    pSource->Release();

    return (hr == S_OK);
}

//+---------------------------------------------------------------------------
//
// UnadviseSingleSink
//
//----------------------------------------------------------------------------

void UnadviseSingleSink(TfClientId tfClientId, IUnknown *pSourceIn, REFIID riid)
{
    ITfSourceSingle *pSource;

    if (pSourceIn->QueryInterface(IID_ITfSourceSingle, (void **)&pSource) == S_OK)
    {
        pSource->UnadviseSingleSink(tfClientId, riid);
        pSource->Release();
    }
}

//+---------------------------------------------------------------------------
//
// IsRangeCovered
//
// Returns TRUE if pRangeTest is entirely contained within pRangeCover.
//----------------------------------------------------------------------------

BOOL IsRangeCovered(TfEditCookie ec, ITfRange *pRangeTest, ITfRange *pRangeCover)
{
    LONG lResult;

    if (pRangeCover->CompareStart(ec, pRangeTest, TF_ANCHOR_START, &lResult) != S_OK ||
        lResult > 0)
    {
        return FALSE;
    }

    if (pRangeCover->CompareEnd(ec, pRangeTest, TF_ANCHOR_END, &lResult) != S_OK ||
        lResult < 0)
    {
        return FALSE;
    }

    return TRUE;
}

//+---------------------------------------------------------------------------
//
// IsEqualUnknown
//
// Returns TRUE if punk1 and punk2 refer to the same object.  We must QI for
// IUnknown to be guarenteed a reliable test, per the COM rules.
//----------------------------------------------------------------------------

BOOL IsEqualUnknown(IUnknown *interface1, IUnknown *interface2)
{
    IUnknown *punk1;
    IUnknown *punk2;

    if (interface1->QueryInterface(IID_IUnknown, (void **)&punk1) != S_OK)
        return FALSE;

    punk1->Release(); // we don't actually need to dereference these guys, just want to compare them

    if (interface2->QueryInterface(IID_IUnknown, (void **)&punk2) != S_OK)
        return FALSE;

    punk2->Release();

    return (punk1 == punk2);
}


//+---------------------------------------------------------------------------
//
// GetCompositionFromContext
//
// ContextComposition𓾂
//----------------------------------------------------------------------------

HRESULT GetCompositionFromContext(ITfContext *pContext, TfEditCookie ec, ITfCompositionSink *pSink, ITfComposition **pComposition) {
	TF_SELECTION tfSelection;
	ULONG cFetched;
	if (pContext->GetSelection(ec, TF_DEFAULT_SELECTION, 1, &tfSelection, &cFetched) != S_OK || cFetched != 1) {
        return TRUE;
	}

    ITfContextComposition *pContextComposition;
    if (pContext->QueryInterface(IID_ITfContextComposition, (void**)&pContextComposition) != S_OK) {
        tfSelection.range->Release();
        return E_FAIL;
    }

	if (pContextComposition->StartComposition(ec, tfSelection.range, pSink, pComposition) != S_OK)
	{
        tfSelection.range->Release();
		pContextComposition->Release();
        return E_FAIL;
	}

    tfSelection.range->Release();
	pContextComposition->Release();
    return S_OK;
}

//+---------------------------------------------------------------------------
//
// AdjustRangeToComposition
//
// ^ꂽRangeComposition͈̔͂ɍ킹
//----------------------------------------------------------------------------
HRESULT AdjustRangeToComposition(TfEditCookie ec, ITfRange* pRange, ITfComposition* pComposition, bool moveStart) {
	ITfRange *pRangeComposition = NULL;
	pComposition->GetRange(&pRangeComposition);
	if (pRangeComposition == NULL) {
		return S_FALSE;
	}

    // RangeCompositionɂ킹
    if (moveStart && pRange->ShiftStartToRange(ec, pRangeComposition, TF_ANCHOR_START) != S_OK) {
        pRangeComposition->Release();
        return S_FALSE;
    }
    if (pRange->ShiftEndToRange(ec, pRangeComposition, TF_ANCHOR_END) != S_OK) {
        pRangeComposition->Release();
        return S_FALSE;
    }
	pRangeComposition->Release();

    return S_OK;
}

//+---------------------------------------------------------------------------
//
// SetTextToComposition
//
// CompositionɃeLXgZbg
//----------------------------------------------------------------------------
HRESULT SetTextToComposition(TfEditCookie ec, ITfContext *pContext, ITfComposition *pComposition, std::wstring text)
{
	TF_SELECTION tfSelection;
	ULONG cFetched;
	if (pContext->GetSelection(ec, TF_DEFAULT_SELECTION, 1, &tfSelection, &cFetched) != S_OK ||
		cFetched != 1)
	{
		return S_FALSE;
	}

    // RangeCompositionɂ킹BsĂ悢̂ŃG[̓`FbNȂB
    AdjustRangeToComposition(ec, tfSelection.range, pComposition, true);

	// Zbg
	tfSelection.range->SetText(ec, TF_ST_CORRECTION, text.c_str(), text.size());
    tfSelection.range->Collapse(ec, TF_ANCHOR_END);

    // 폜ςRangeZbg
	pContext->SetSelection(ec, 1, &tfSelection);
    tfSelection.range->Release();

	return S_OK;
}
