#pragma once
#ifndef WINDOW_SOFTWARE_INFORMATION_H
#define WINDOW_SOFTWARE_INFORMATION_H

#include "WindowCommon.h"

#define SOFT_INFO_FILE_NAME L"software_info.txt"
#define SOFT_INFO_BUTTON_TITLE  L"Software Information"
#define BUTTON_ID_SOFT_INFO_CLOSE 6100

namespace GUI {
	// \tgEFAEChENX
	class CWindowSoftwareInformation : public CWindowCommonNative
	{
	private:
		// EChEnh
		HWND _hVersionWnd;
		HWND _hStaticSoftInfo;
		HWND _hButtonSoftInfoClose;

		// o[{^ID
		std::size_t button_id_;

	private:
		// \tgEFAݒ
		BOOL SetSoftwareInfoText();

	public:
		// RXgN^
		CWindowSoftwareInformation();
		// fXgN^
		virtual ~CWindowSoftwareInformation();
		// EChE̐
		BOOL Create(LPVOID parent, WNDPROC wndProc, HINSTANCE hInstance);
		// EChE̔j
		void Destroy();
		// EChE̕\
		void Show(BOOL bShow);

		void SetButtonID(std::size_t id) { button_id_ = id; }
		std::size_t GetButtonID() { return button_id_; }
	};
}
#endif // WINDOW_SOFTWARE_INFORMATION_H
