#define NOMINMAX

#include "WindowSoftwareInformation.h"
#include <commctrl.h>
#include <string>
#include <limits>

#include "FolderUtil.h"

using namespace std;
using namespace GUI;

// RXgN^
CWindowSoftwareInformation::CWindowSoftwareInformation() : button_id_((std::numeric_limits<std::size_t>::max()))
{
	m_lpszClassName = TEXT("Software Information Class");
	m_lpszWindowName = TEXT("Software Information");
	_hVersionWnd = NULL;
	_hStaticSoftInfo = NULL;
	_hButtonSoftInfoClose = NULL;
}

// fXgN^
CWindowSoftwareInformation::~CWindowSoftwareInformation()
{
	Destroy();
}

// EChE̔j
void CWindowSoftwareInformation::Destroy()
{
	DestroyWnd(_hButtonSoftInfoClose);
	DestroyWnd(_hStaticSoftInfo);
	DestroyWnd(_hVersionWnd);

	UnregisterClass(m_lpszClassName, m_hInstance);
}

// EChE̕\
void CWindowSoftwareInformation::Show(BOOL bShow)
{
	LogOutput(__FUNCTION__, __LINE__, "bShow = %d", bShow);
	if (bShow == TRUE) {
		// \tgEFAݒ
		SetSoftwareInfoText();
		ShowWindowCenter(_hVersionWnd);
	}
	else {
		ShowWindow(_hVersionWnd, SW_HIDE);
	}
}

// EChE̐
BOOL CWindowSoftwareInformation::Create(LPVOID parent, WNDPROC wndProc, HINSTANCE hInstance)
{
	m_parent = parent;
	m_wndProc = wndProc;
	m_hInstance = hInstance;

	// EChENXo^
	if (RegistClass() == FALSE) {
		return FALSE;
	}

	// \tgEFA񃁃CEChE
	_hVersionWnd = CreateWindow(
		// EBhENX
		m_lpszClassName,
		// LvV
		m_lpszWindowName,
		// X^Cw
		0,
		// W
		CW_USEDEFAULT, CW_USEDEFAULT,
		// TCY
		300, 230,
		// eEBhẼnh
		NULL,
		// j[nh
		NULL,
		// CX^Xnh
		m_hInstance,
		// ̑̍쐬f[^
		m_parent
	);

	// X^eBbNRg[쐬
	_hStaticSoftInfo = CreateWindow(
		// EBhENX
		TEXT("STATIC"),
		// LvV
		TEXT("Copyright(c) 2019, National Institute of Information and Communications Technology(NICT). All right reserved."),
		// X^Cw
		SS_NOPREFIX | WS_CHILD | WS_VISIBLE,
		// W
		50, 20,
		// TCY
		200, 150,
		// eEBhẼnh
		_hVersionWnd,
		// j[nh
		NULL,
		// CX^Xnh
		m_hInstance,
		// ̑̍쐬f[^
		m_parent
	);

	// vbV{^쐬
	_hButtonSoftInfoClose = CreateWindow(
		// EBhENX
		TEXT("BUTTON"),
		// LvV
		TEXT("close"),
		// X^Cw
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		// W
		90, 150,
		// TCY
		100, 30,
		// eEBhẼnh
		_hVersionWnd,
		// j[nh
		(HMENU)BUTTON_ID_SOFT_INFO_CLOSE,
		// CX^Xnh
		m_hInstance,
		// ̑̍쐬f[^
		m_parent
	);

	return (_hVersionWnd != NULL);
}

// \tgEFAݒ
BOOL CWindowSoftwareInformation::SetSoftwareInfoText()
{
	// [U[tH_AKKHARAtH_̃pX擾
	TCHAR tcsUserAkkharaDir[INSTALL_FOLDER_PATH_MAX_LENGTH];
	GetInstallFolderPath(tcsUserAkkharaDir);
	wstring wstrAkkharaDir = tcsUserAkkharaDir;
	LogOutputW(__FUNCTION__, __LINE__, L"strAkkharaDir [%s]", wstrAkkharaDir.c_str());
	wstring wstrSoftwareInfoFilePath = wstrAkkharaDir + L"\\" + SOFT_INFO_FILE_NAME;

	// o[Wǂݍރt@CTCY擾
	struct _stat buf;
	int result = _wstat(wstrSoftwareInfoFilePath.c_str(), &buf);
	if (result != 0)
	{
		LogOutput(__FUNCTION__, __LINE__, "AKKHARA get file size error.");
		return FALSE;
	}

	// o[Wt@Cǂݍ
	char* sBuf;
	sBuf = new char[buf.st_size + 1];
	memset(sBuf, 0, buf.st_size + 1);

	FILE* fp = _wfopen(wstrSoftwareInfoFilePath.c_str(), TEXT("rt"));
	if (fp == NULL) {
		LogOutput(__FUNCTION__, __LINE__, "AKKHARA file open error.");
		return FALSE;
	}

	fread(sBuf, buf.st_size, sizeof(char), fp);
	fclose(fp);

	// ǂݍ񂾃o[Wʂɕ\
	SetWindowTextA(_hStaticSoftInfo, sBuf);

	delete sBuf;

	return TRUE;
}