#pragma once
#ifndef WINDOW_INPUT_TEXT_H
#define WINDOW_INPUT_TEXT_H

#include "WindowCommon.h"
#include <msctf.h>
#include "CursorManager.h"


#define FONT_SIZE 36
#define TEXT_SHOW_MARGIN 10

namespace GUI {
	class CWindowInputTextCommon
	{
	public:
		CWindowInputTextCommon() {}
		virtual ~CWindowInputTextCommon() {}

		// EChE̐
		virtual BOOL Create(LPVOID parent, WNDPROC wndProc, HINSTANCE hInstance, HWND hWnd) = 0;
		// EChE̔j
		virtual void Destroy() = 0;

		virtual void Show(BOOL bShow) = 0;

		void SetText(std::wstring wstrText, RECT prc) {
			last_ = wstrText;
			if (TSF::CursorManager::IsUninitialized(prc)) {
				return;
			}
			SetText_(wstrText, prc);
			previous_prc_ = prc;
		}
		void RetryShowing(RECT prc) {
			if (last_ == L"") {
				return;
			}
			if (!TSF::CursorManager::IsUninitialized(prc)) {
				auto diff_left = abs(previous_prc_.left - prc.left);
				auto diff_top = abs(previous_prc_.bottom - prc.bottom);
				if (diff_left > 10 || diff_top > 10) {
					// 傫ړƂ͂
					Show(FALSE);
				}
			}
			Show(TRUE);
			SetText(last_, prc);
		}

	protected:
		virtual void SetText_(std::wstring wstrText, RECT prc) = 0;
		COLORREF GetBackGroundColor() {
			return colorBackGround_;
		}

	private:
		std::wstring last_;
		RECT previous_prc_;
		COLORREF colorBackGround_ = RGB(211, 211, 211);
	};

	// ̓eLXgEChENX(UWPAv)
	class CWindowInputTextNative : public CWindowCommonNative, public CWindowInputTextCommon
	{
	private:
		// EChEnh
		HWND _hInputTextWnd;

		// tHg
		HFONT _hFont;
		HFONT _hFontOld;
		// foCXReLXg
		HDC _hdc;
		// uV
		HBRUSH _hBrush;
		// EChE\tO
		BOOL _bShow;

		HWND hWndGlobal_;

	public:
		CWindowInputTextNative();
		virtual ~CWindowInputTextNative();

		virtual BOOL Create(LPVOID parent, WNDPROC wndProc, HINSTANCE hInstance, HWND hWnd);
		virtual void Destroy();
		virtual void Show(BOOL bShow);

	protected:
		virtual void SetText_(std::wstring wstrText, RECT prc);

	private:
		int FontSizeToFontHeight(int font_size);
	};

	// ̓eLXgEChENX(UWPAv)
	class CWindowInputTextUWP : public CWindowInputTextCommon {
	private:
		Windows::UI::Xaml::Controls::Primitives::Popup ^popup;
		Windows::UI::Xaml::Controls::TextBox ^textBox;

		BOOL opened;

	public:
		CWindowInputTextUWP();
		virtual ~CWindowInputTextUWP() {};

		virtual BOOL Create(LPVOID parent, WNDPROC wndProc, HINSTANCE hInstance, HWND hWnd);
		virtual void Destroy() {};
		virtual void Show(BOOL bShow);

	protected:
		virtual void SetText_(std::wstring wstrText, RECT prc);
	};
}
#endif // WINDOW_INPUT_TEXT_H
