#include "WindowInputText.h"
#include <commctrl.h>
#include <string>
#include <msctf.h>
#include "uwp_util.h"

#define SHOW_CARET_POS
#define BROWSER_LEFT_TOP

using namespace std;
using namespace GUI;

// RXgN^
CWindowInputTextNative::CWindowInputTextNative() : CWindowInputTextCommon()
{
	m_lpszClassName = TEXT("Input Text Class");
	m_lpszWindowName = TEXT("Input Text");
	_hInputTextWnd = NULL;
	_bShow = FALSE;
}

// fXgN^
CWindowInputTextNative::~CWindowInputTextNative()
{
	Destroy();
	// tHg߂
	SelectObject(_hdc, _hFontOld);
	// tHg폜
	DeleteObject(_hFont);
	// foCXReLXg
	ReleaseDC(_hInputTextWnd, _hdc);
	// uV
	DeleteObject(_hBrush);
}

// EChE̔j
void CWindowInputTextNative::Destroy()
{
	DestroyWnd(_hInputTextWnd);

	UnregisterClass(m_lpszClassName, m_hInstance);
}

// EChE̕\
void CWindowInputTextNative::Show(BOOL bShow)
{
	// LogOutput(__FUNCTION__, __LINE__, "bShow = %d _bShow %d", bShow, _bShow);
	if (bShow == TRUE) {
		if (_bShow == FALSE) {
			ShowWindow(_hInputTextWnd, SW_SHOWNA);
		}
	}
	else {
		// LogOutput(__FUNCTION__, __LINE__, "CloseWindow");
		ShowWindow(_hInputTextWnd, SW_HIDE);
	}
	_bShow = bShow;
}

// tHgTCYtHg̍ɕϊ
int CWindowInputTextNative::FontSizeToFontHeight(int font_size)
{
	int height = ::MulDiv(font_size, GetDeviceCaps(_hdc, LOGPIXELSY), 72);
//	LogOutput(__FUNCTION__, __LINE__, "height [%d]", height);
	return height;
}

// EChE̐
BOOL CWindowInputTextNative::Create(LPVOID parent, WNDPROC wndProc, HINSTANCE hInstance, HWND hWnd)
{
	m_parent = parent;
	m_wndProc = wndProc;
	m_hInstance = hInstance;
	hWndGlobal_ = hWnd;

	// EChENXo^
	if (RegistClass() == FALSE) {
		return FALSE;
	}

	// ̓eLXgCEChE
	_hInputTextWnd = CreateWindow(
		// EBhENX
		m_lpszClassName,
		// LvV
		m_lpszWindowName,
		// X^Cw
//		0,
//		WS_OVERLAPPED | WS_EX_CLIENTEDGE | WS_DISABLED,
//		WS_BORDER,
//		WS_POPUP,
		WS_POPUP | WS_DISABLED,
//		WS_CHILD | WS_EX_CLIENTEDGE | WS_DISABLED,
		// W
		CW_USEDEFAULT, CW_USEDEFAULT,
		// TCY
		CW_USEDEFAULT, CW_USEDEFAULT,
		// eEBhẼnh
		hWnd,
		// j[nh
		NULL,
		// CX^Xnh
		m_hInstance,
		// ̑̍쐬f[^
		m_parent
	);

	// foCXReLXg擾
	_hdc = GetDC(_hInputTextWnd);

	// ̓eLXgCEChẼtHgݒ
	_hFont = CreateFont(
		//tHg
		FontSizeToFontHeight(FONT_SIZE),
		//
		0,
		//eLXg̊px
		0,
		//x[XCƂƂ̊px
		0,
		//tHg̏dij
		FW_REGULAR,
		//C^bN
		FALSE,
		//A_[C
		FALSE,
		//ł
		FALSE,
		//Zbg
		SHIFTJIS_CHARSET,
		//o͐x
		OUT_DEFAULT_PRECIS,
		//NbsOx
		CLIP_DEFAULT_PRECIS,
		//o͕i
		PROOF_QUALITY,
		//sb`ƃt@~[
		FIXED_PITCH | FF_MODERN,
		//̖
		(LPCTSTR)"lr SVbN"
	);

	// tHgI
	_hFontOld = (HFONT)SelectObject(_hdc, _hFont);
	// wihԂp̃uV𐶐
	_hBrush = CreateSolidBrush(GetBackGroundColor());
	// wiFݒ
	SetBkColor(_hdc, GetBackGroundColor());

	return (_hInputTextWnd != NULL);
}

// EChEɃeLXg\
void CWindowInputTextNative::SetText_(wstring wstrText, RECT prc)
{
	// LbgʒủɃEChE\
	
	// \̈̃TCY̎擾
	SIZE ptText;
	GetTextExtentPoint32(_hdc, wstrText.c_str(), wstrText.size(), &ptText);
	// LogOutput(__FUNCTION__, __LINE__, "(%d %d) %d %d [%d]", prc.left, prc.bottom, ptText.cx, ptText.cy, wstrText.size());

	MoveWindow(_hInputTextWnd, prc.left, prc.bottom, ptText.cx, ptText.cy + TEXT_SHOW_MARGIN, FALSE);
	RECT rectInputText;
	rectInputText.left = 0;
	rectInputText.top = 0;
	rectInputText.right = ptText.cx;
	rectInputText.bottom = ptText.cy + TEXT_SHOW_MARGIN;

	FillRect(_hdc, &rectInputText, _hBrush);
	// `悷
	DrawText(_hdc, wstrText.c_str(), wstrText.size(), &rectInputText, DT_WORDBREAK);
}

//////////////////////////////////////
////  UWP Av|bvAbv  ////
//////////////////////////////////////


CWindowInputTextUWP::CWindowInputTextUWP() : CWindowInputTextCommon()
{
	popup = nullptr;

	textBox = ref new Windows::UI::Xaml::Controls::TextBox();
	textBox->BorderThickness = Windows::UI::Xaml::Thickness(0);
	Windows::UI::Color background{};
	background.R = GetRValue(GetBackGroundColor());
	background.G = GetGValue(GetBackGroundColor());
	background.B = GetBValue(GetBackGroundColor());
	background.A = 0xFF;
	textBox->Background = ref new Windows::UI::Xaml::Media::SolidColorBrush(background);
	textBox->Foreground = ref new Windows::UI::Xaml::Media::SolidColorBrush(Windows::UI::Colors::Black);
	textBox->IsReadOnly = true;
	textBox->FontSize = FONT_SIZE;
}

BOOL CWindowInputTextUWP::Create(LPVOID parent, WNDPROC wndProc, HINSTANCE hInstance, HWND hWnd)
{
	popup = ref new Windows::UI::Xaml::Controls::Primitives::Popup();
	// popup->AllowFocusOnInteraction = false;
	popup->Child = textBox;

	return TRUE;
}

void CWindowInputTextUWP::Show(BOOL bShow)
{
	if (bShow == TRUE) {
		if (opened == FALSE) {
			opened = TRUE;
		}
	}
	else {
		opened = FALSE;
		if (popup != nullptr) {
			popup->IsOpen = false;
		}
	}
}

void CWindowInputTextUWP::SetText_(wstring wstrText, RECT prc)
{
	// LbgʒủɃEChE\
	if (opened) {
		// UWPAvŃ|bvAbv\ĂƂ
		Platform::String^ c = ref new Platform::String(wstrText.c_str());
		textBox->Text = c;

		// ʒuZbg
		Windows::UI::Xaml::Window^ w = Windows::UI::Xaml::Window::Current;
		auto r = w->CoreWindow->Bounds;
		popup->HorizontalOffset = prc.left - r.Left;
		popup->VerticalOffset = prc.bottom - r.Top;

		if (popup->IsOpen && wstrText.length() == 0) {
			popup->IsOpen = false;
		}
		else if (wstrText.length() > 0 && !popup->IsOpen) {
			popup->IsOpen = true;
		}
	}
}
