#pragma once
#ifndef WINDOW_CONVERSION_RULE_H
#define WINDOW_CONVERSION_RULE_H

#include "WindowCommon.h"
#include "AkkharaConversionTable.h"

#define BUTTON_ID_CONVERSION_RULE_CLOSE 6000
#define CONV_RULE_BUTTON_TITLE L"Conversion Rule"
#define TUB_ID_CONVERSION_RULE 6001

#ifndef ListView_SetCheckState
#define ListView_SetCheckState(hwndLV, i, fCheck) \
      ListView_SetItemState(hwndLV, i, \
      INDEXTOSTATEIMAGEMASK((fCheck)+1), LVIS_STATEIMAGEMASK)
#endif

namespace GUI {
	// ϊ[EChENX
	class CWindowConversionRule : public CWindowCommonNative
	{
	private:
		// EChEnh
		HWND _hConversionRuleWnd;
		HWND _hStaticLanguageTitle;
		HWND _hStaticLanguageName;
		HWND _hTabCtrl;
		HWND _hListViewCustom;
		HWND _hListViewApplication;
		HWND _hButtonConversionRuleClose;

		// AKKHARAϊe[uNX
		CAkkharaConversionTable* m_pAkkhara;

		// o[{^ID
		std::size_t button_id_;

	private:
		// Customization^ũf[^Zbg
		void SetCustomizationTab();
		// ʕ\쐬(Customization)
		std::wstring MakeCustomizationStr(std::vector<std::wstring> wstrShow, std::vector<std::wstring> wstrConv);
		// Application^ũf[^Zbg
		void SetApplicationTab();
		// ʕ\쐬(Application KeyInput)
		std::wstring MakeApplicationKeyInputStr(std::vector<std::wstring> wstr);
		// ʕ\쐬(Application)
		std::wstring MakeApplicationStr(std::vector<std::wstring> wstrShow, std::vector<std::wstring> wstrConv);

	public:
		// RXgN^
		CWindowConversionRule();
		// fXgN^
		virtual ~CWindowConversionRule();
		// EChE̐
		BOOL Create(LPVOID parent, WNDPROC wndProc, HINSTANCE hInstance);
		// EChE̔j
		void Destroy();
		// EChE̕\
		void Show(BOOL bShow);
		// EChẼ^u؂ւ
		void ChangeTab();
		// CAkkharaConversionTableNXZbg
		void SetAkkhara(CAkkharaConversionTable* pAkkhara);
		// ϊ[ݒ̍XV
		void ConversionRuleUpdate();
		// ꖼeLXg\
		void SetTextLanguage(std::wstring wstr);

		void SetButtonID(std::size_t id) { button_id_ = id; }
		std::size_t GetButtonID() { return button_id_; }
	};
}
#endif // WINDOW_CONVERSION_RULE_H
