#define NOMINMAX

#include "WindowConversionRule.h"
#include <commctrl.h>
#include <string>

using namespace std;
using namespace GUI;

// RXgN^
CWindowConversionRule::CWindowConversionRule(): button_id_(std::numeric_limits<std::size_t>::max())
{
	m_lpszClassName = TEXT("Conversion Rule Class");
	m_lpszWindowName = TEXT("Conversion Rule");
	_hConversionRuleWnd = NULL;
	_hStaticLanguageTitle = NULL;
	_hStaticLanguageName = NULL;
	_hTabCtrl = NULL;
	_hListViewCustom = NULL;
	_hListViewApplication = NULL;
	_hButtonConversionRuleClose = NULL;
}

// fXgN^
CWindowConversionRule::~CWindowConversionRule()
{
	Destroy();
}


// EChE̐
BOOL CWindowConversionRule::Create(LPVOID parent, WNDPROC wndProc, HINSTANCE hInstance)
{
	m_parent = parent;
	m_wndProc = wndProc;
	m_hInstance = hInstance;

	// EChENXo^
	if (RegistClass() == FALSE) {
		return FALSE;
	}

	int windowWhdth = 600;
	int windowWhdthMargin = 20;
	int windowHeight = 600;
	int titleTop = 10;
	int tabTop = 40;
	int listTop = tabTop + 30;
	int listHeight = 420;
	int useColumnWidth = 30;
	int btnWidth = 120;
	int btnHeight = 30;
	int btnHeightMargin = 20;

	// ϊ[ݒ胁CEChE
	_hConversionRuleWnd = CreateWindow(
		// EBhENX
		m_lpszClassName,
		// LvV
		m_lpszWindowName,
		// X^Cw
		0,
		// W
		0, 0,
		// TCY
		windowWhdth, windowHeight,
		// eEBhẼnh
		NULL,
		// j[nh
		NULL,
		// CX^Xnh
		m_hInstance,
		// ̑̍쐬f[^
		m_parent
	);

	// ϊ[ݒ胁CEChE̍W擾
	static RECT rc;
	GetClientRect(_hConversionRuleWnd, &rc);

	// X^eBbNRg[쐬
	_hStaticLanguageTitle = CreateWindow(
		// EBhENX
		TEXT("STATIC"),
		// LvV
		TEXT("Language"),
		// X^Cw
		SS_NOPREFIX | WS_CHILD | WS_VISIBLE | SS_CENTER,
		// W
		((rc.right - rc.left) / 4), titleTop,
		// TCY
		(rc.right - rc.left) / 4, tabTop - titleTop,
		// eEBhẼnh
		_hConversionRuleWnd,
		// j[nh
		NULL,
		// CX^Xnh
		m_hInstance,
		// ̑̍쐬f[^
		m_parent
	);

	// X^eBbNRg[쐬
	_hStaticLanguageName = CreateWindow(
		// EBhENX
		TEXT("STATIC"),
		// LvV
		TEXT("Language"),
		// X^Cw
		SS_NOPREFIX | WS_CHILD | WS_VISIBLE | SS_CENTER,
		// W
		((rc.right - rc.left) / 4) * 2, titleTop,
		// TCY
		(rc.right - rc.left) / 4, tabTop - titleTop,
		// eEBhẼnh
		_hConversionRuleWnd,
		// j[nh
		NULL,
		// CX^Xnh
		m_hInstance,
		// ̑̍쐬f[^
		m_parent
	);

	// ^uRg[쐬
	_hTabCtrl = CreateWindowEx(
		0,
		// EBhENX
		WC_TABCONTROL,
		// LvV
		TEXT(""),
		// X^Cw
		WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE,
		// W
		0, tabTop,
		// TCY
		rc.right - rc.left, rc.bottom - rc.top - tabTop,
		// eEBhẼnh
		_hConversionRuleWnd,
		// j[nh
		(HMENU)TUB_ID_CONVERSION_RULE,
		// CX^Xnh
		m_hInstance,
		// ̑̍쐬f[^
		m_parent
	);

	TCITEM ti;
	ti.mask = TCIF_TEXT;
	ti.pszText = TEXT("Customization");
	TabCtrl_InsertItem(_hTabCtrl, 0, &ti);
	ti.pszText = TEXT("Application");
	TabCtrl_InsertItem(_hTabCtrl, 1, &ti);

	// Xgr[Rg[쐬(Customization)
	_hListViewCustom = CreateWindow(
		// EBhENX
		TEXT("syslistview32"),
		// LvV
		0,
		// X^Cw
		WS_CHILD | WS_VISIBLE | LVS_REPORT,
		// W
		0, listTop,
		// TCY
		windowWhdth, listHeight,
		// eEBhẼnh
		_hConversionRuleWnd,
		// j[nh
		NULL,
		// CX^Xnh
		m_hInstance,
		// ̑̍쐬f[^
		m_parent
	);
	// Xgr[Ƀ`FbN{bNXgp
	ListView_SetExtendedListViewStyleEx(_hListViewCustom, LVS_EX_CHECKBOXES | LVS_EX_GRIDLINES, LVS_EX_CHECKBOXES | LVS_EX_GRIDLINES);

	// Xgr[̃wb_ݒ(Customization)
	LVCOLUMN col;
	LVITEM item = { 0 };
	int iCount = 0;
	col.mask = LVCF_FMT | LVCF_TEXT | LVCF_WIDTH;
	col.fmt = LVCFMT_CENTER;
	col.cx = useColumnWidth;
	col.pszText = L"use";
	ListView_InsertColumn(_hListViewCustom, 0, &col);
	col.cx = (windowWhdth - windowWhdthMargin - useColumnWidth) / 2;
	col.pszText = L"input";
	ListView_InsertColumn(_hListViewCustom, 1, &col);
	col.cx = (windowWhdth - windowWhdthMargin - useColumnWidth) / 2;
	col.pszText = L"output";
	ListView_InsertColumn(_hListViewCustom, 2, &col);

	// Xgr[Rg[쐬(Application)
	_hListViewApplication = CreateWindow(
		// EBhENX
		TEXT("syslistview32"),
		// LvV
		0,
		// X^Cw
		WS_CHILD | WS_VISIBLE | LVS_REPORT,
		// W
		0, listTop,
		// TCY
		windowWhdth, listHeight,
		// eEBhẼnh
		_hConversionRuleWnd,
		// j[nh
		NULL,
		// CX^Xnh
		m_hInstance,
		// ̑̍쐬f[^
		m_parent
	);

	// Xgr[̃wb_ݒ(Application)
	col.mask = LVCF_FMT | LVCF_TEXT | LVCF_WIDTH;
	col.fmt = LVCFMT_CENTER;
	col.cx = 0;
	col.pszText = L"";
	ListView_InsertColumn(_hListViewApplication, 0, &col);
	col.cx = (windowWhdth - windowWhdthMargin) / 2;
	col.pszText = L"input";
	ListView_InsertColumn(_hListViewApplication, 1, &col);
	col.cx = (windowWhdth - windowWhdthMargin) / 2;
	col.pszText = L"output";
	ListView_InsertColumn(_hListViewApplication, 2, &col);

	// vbV{^쐬
	_hButtonConversionRuleClose = CreateWindow(
		// EBhENX
		TEXT("BUTTON"),
		// LvV
		TEXT("close"),
		// X^Cw
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		// W
		((rc.right - rc.left) / 2) - (btnWidth / 2), listTop + listHeight + btnHeightMargin,
		// TCY
		btnWidth, btnHeight,
		// eEBhẼnh
		_hConversionRuleWnd,
		// j[nh
		(HMENU)BUTTON_ID_CONVERSION_RULE_CLOSE,
		// CX^Xnh
		m_hInstance,
		// ̑̍쐬f[^
		NULL
	);

	// ftHgłCustomizatioñ^u\
	ShowWindow(_hListViewCustom, SW_SHOW);
	ShowWindow(_hListViewApplication, SW_HIDE);

	return (_hConversionRuleWnd != NULL);
}

// EChE̔j
void CWindowConversionRule::Destroy()
{
	DestroyWnd(_hButtonConversionRuleClose);
	DestroyWnd(_hListViewApplication);
	DestroyWnd(_hListViewCustom);
	DestroyWnd(_hTabCtrl);
	DestroyWnd(_hStaticLanguageTitle);
	DestroyWnd(_hStaticLanguageName);
	DestroyWnd(_hConversionRuleWnd);

	UnregisterClass(m_lpszClassName, m_hInstance);
}

// EChE̕\
void CWindowConversionRule::Show(BOOL bShow)
{
	LogOutput(__FUNCTION__, __LINE__, "bShow = %d", bShow);
	if (bShow == TRUE) {
		ShowWindowCenter(_hConversionRuleWnd);
	}
	else {
		ShowWindow(_hConversionRuleWnd, SW_HIDE);
	}
}

// EChẼ^u؂ւ
void CWindowConversionRule::ChangeTab()
{
	if (TabCtrl_GetCurSel(_hTabCtrl) == 0) {
		ShowWindow(_hListViewCustom, SW_SHOWNA);
		ShowWindow(_hListViewApplication, SW_HIDE);
	}
	else {
		ShowWindow(_hListViewCustom, SW_HIDE);
		ShowWindow(_hListViewApplication, SW_SHOWNA);
	}
}

// CAkkharaConversionTableNXZbg
void CWindowConversionRule::SetAkkhara(CAkkharaConversionTable* pAkkhara)
{
	m_pAkkhara = pAkkhara;
	m_pAkkhara->DebugLog();

	// Customization^ũf[^Zbg
	SetCustomizationTab();
	// Application^ũf[^Zbg
	SetApplicationTab();
}

// ʕ\쐬(Customization)
wstring CWindowConversionRule::MakeCustomizationStr(std::vector<wstring> wstrShow, std::vector<wstring> wstrConv)
{
	wstring text = L"";
	wchar_t cwText[256];
	wstring textAll = L"";
	memset(cwText, 0, sizeof(wchar_t) * 256);

	for (size_t i = 0; i < wstrConv.size(); i++) {
		text += wstrConv[i];
		if (i == wstrConv.size() - 1) {
			text += L" = ";
		}
		else {
			text += L" + ";
		}
		textAll += wstrConv[i];
	}

	text += textAll;

	text += L" (";
	for (size_t i = 0; i < wstrShow.size(); i++) {
		text += wstrShow[i];
		text += L" ";
	}
	text += L")";

	return text;
}


// Customization^ũf[^Zbg
void CWindowConversionRule::SetCustomizationTab()
{
	// Xgr[̃ACeׂč폜
	ListView_DeleteAllItems(_hListViewCustom);

	LVITEM item = { 0 };
	int itemCount = 0;

	wchar_t cwWords[256];
	wchar_t cwText[256];
	memset(cwWords, 0, sizeof(wchar_t) * 256);
	memset(cwText, 0, sizeof(wchar_t) * 256);
	wstring text = L"";

	for (size_t i = 0; i < m_pAkkhara->GetConversionOrdersNum(); i++) {
		for (size_t j = 0; j < m_pAkkhara->GetConversionNum(i); j++) {
			CAkkharaConversionData akkharaConv = m_pAkkhara->GetConversion(i, j);
			if (akkharaConv.GetUseFlag() == 0) {
				continue;
			}

			item.mask = LVIF_TEXT;
			item.pszText = L"";
			item.iItem = itemCount;
			item.iSubItem = 0;
			ListView_InsertItem(_hListViewCustom, &item);

			// `FbN{bNX
			if (akkharaConv.GetUseFlag() == 1) {
				ListView_SetCheckState(_hListViewCustom, itemCount, 1);
			}
			else if (akkharaConv.GetUseFlag() == -1) {
				ListView_SetCheckState(_hListViewCustom, itemCount, 0);
			}

			// ʕ\쐬(Application Output)
			text = MakeCustomizationStr(akkharaConv.GetBeforeWordsShow(), akkharaConv.GetBeforeWords());
			item.mask = LVIF_TEXT;
			item.pszText = (LPWSTR)text.c_str();
			item.iItem = itemCount;
			item.iSubItem = 1;
			ListView_SetItem(_hListViewCustom, &item);

			// ʕ\쐬(Application Output)
			text = MakeCustomizationStr(akkharaConv.GetAfterWordsShow(), akkharaConv.GetAfterWords());
			item.pszText = (LPWSTR)text.c_str();
			item.iItem = itemCount;
			item.iSubItem = 2;
			ListView_SetItem(_hListViewCustom, &item);

			itemCount++;
		}
	}
}

// ʕ\쐬(Application KeyInput)
wstring CWindowConversionRule::MakeApplicationKeyInputStr(std::vector<wstring> wstr)
{
	wstring text = L"";
	for (size_t i = 0; i < wstr.size(); i++) {
		text += wstr[i];
	}

	return text;
}

// ʕ\쐬(Application)
wstring CWindowConversionRule::MakeApplicationStr(std::vector<wstring> wstrShow, std::vector<wstring> wstrConv)
{
	wstring text = L"";

	for (size_t i = 0; i < wstrConv.size(); i++) {
		text += wstrConv[i];
	}

	text += L" (";
	for (size_t i = 0; i < wstrShow.size(); i++) {
		text += wstrShow[i];
		text += L" ";
	}
	text += L")";

	return text;
}

// Application^ũf[^Zbg
void CWindowConversionRule::SetApplicationTab()
{
	// Xgr[̃ACeׂč폜
	ListView_DeleteAllItems(_hListViewApplication);

	LVITEM item = { 0 };
	int itemCount = 0;

	wchar_t cwWords[256];
	wchar_t cwText[256];
	memset(cwWords, 0, sizeof(wchar_t) * 256);
	memset(cwText, 0, sizeof(wchar_t) * 256);
	wstring text = L"";

	for (size_t i = 0; i < m_pAkkhara->GetKeyInputNum(); i++) {
		CAkkharaConversionData akkharaConv = m_pAkkhara->GetKeyInput(i);
		if (akkharaConv.GetUseFlag() != 0) {
			continue;
		}

		item.mask = LVIF_TEXT;
		item.pszText = L"";
		item.iItem = itemCount;
		item.iSubItem = 0;
		ListView_InsertItem(_hListViewApplication, &item);

		// ʕ\쐬(Application KeyInput)
		text = MakeApplicationKeyInputStr(akkharaConv.GetBeforeWordsShow());
		item.mask = LVIF_TEXT;
		item.pszText = (LPWSTR)text.c_str();
		item.iItem = itemCount;
		item.iSubItem = 1;
		ListView_SetItem(_hListViewApplication, &item);

		// ʕ\쐬(Application Output)
		text = MakeApplicationStr(akkharaConv.GetAfterWordsShow(), akkharaConv.GetAfterWords());
		item.pszText = (LPWSTR)text.c_str();
		item.iItem = itemCount;
		item.iSubItem = 2;
		ListView_SetItem(_hListViewApplication, &item);

		itemCount++;
	}

	for (size_t i = 0; i < m_pAkkhara->GetConversionOrdersNum(); i++) {
		for (size_t j = 0; j < m_pAkkhara->GetConversionNum(i); j++) {
			CAkkharaConversionData akkharaConv = m_pAkkhara->GetConversion(i, j);
			if (akkharaConv.GetUseFlag() != 0) {
				continue;
			}

			item.mask = LVIF_TEXT;
			item.pszText = L"";
			item.iItem = itemCount;
			item.iSubItem = 0;
			ListView_InsertItem(_hListViewApplication, &item);

			// ʕ\쐬(Application Output)
			text = MakeApplicationStr(akkharaConv.GetBeforeWordsShow(), akkharaConv.GetAfterWords());
			item.mask = LVIF_TEXT;
			item.pszText = (LPWSTR)text.c_str();
			item.iItem = itemCount;
			item.iSubItem = 1;
			ListView_SetItem(_hListViewApplication, &item);

			// ʕ\쐬(Application Output)
			text = MakeApplicationStr(akkharaConv.GetAfterWordsShow(), akkharaConv.GetAfterWords());
			item.pszText = (LPWSTR)text.c_str();
			item.iItem = itemCount;
			item.iSubItem = 2;
			ListView_SetItem(_hListViewApplication, &item);

			itemCount++;
		}
	}
}

// ϊ[ݒ̍XV
void CWindowConversionRule::ConversionRuleUpdate()
{
	int itemCount = 0;
	for (size_t i = 0; i < m_pAkkhara->GetConversionOrdersNum(); i++) {
		for (size_t j = 0; j < m_pAkkhara->GetConversionNum(i); j++) {
			CAkkharaConversionData akkharaConv = m_pAkkhara->GetConversion(i, j);
			if (akkharaConv.GetUseFlag() == 0) {
				continue;
			}

			if (ListView_GetCheckState(_hListViewCustom, itemCount) == TRUE) {
				m_pAkkhara->UpdateUseFlag(i, j, 1);
			}
			else {
				m_pAkkhara->UpdateUseFlag(i, j, -1);
			}
			itemCount++;
		}
	}
	m_pAkkhara->DebugLog();
}

// ꖼeLXg\
void CWindowConversionRule::SetTextLanguage(wstring wstr)
{
	SetWindowTextW(_hStaticLanguageName, wstr.c_str());
}
