#include "pch.h"
#include "CppUnitTest.h"
#include "../KeyboardManager.h"

using namespace Microsoft::VisualStudio::CppUnitTestFramework;

namespace UnitTest
{
	TEST_CLASS(UnitTest)
	{
	public:
		
		TEST_METHOD(TestJpKeyboardManager_Available_Number)
		{
			KeyboardUtils::JpKeyboardManager manager;
			for (int i = 0; i < 10; ++i) {
				auto actual = manager.Available('0' + i);
				Assert::IsTrue(TRUE);
			}
		}

		TEST_METHOD(TestJpKeyboardManager_Available_Alphabet)
		{
			KeyboardUtils::JpKeyboardManager manager;
			for (int i = 0; i < 26; ++i) {
				auto actual = manager.Available('A' + i);
				Assert::IsTrue(actual);
			}
		}

		TEST_METHOD(TestJpKeyboardManager_Available_Symbols)
		{
			KeyboardUtils::JpKeyboardManager manager;
			Assert::IsTrue(manager.Available(0xBA));
			Assert::IsTrue(manager.Available(0xBB));
			Assert::IsTrue(manager.Available(0xBC));
			Assert::IsTrue(manager.Available(0xBD));
			Assert::IsTrue(manager.Available(0xBE));
			Assert::IsTrue(manager.Available(0xBF));
			Assert::IsFalse(manager.Available(0xC0));
			Assert::IsTrue(manager.Available(0xDB));
			Assert::IsTrue(manager.Available(0xDC));
			Assert::IsTrue(manager.Available(0xDD));
			Assert::IsTrue(manager.Available(0xDE));
			Assert::IsTrue(manager.Available(0xFF));
		}

		TEST_METHOD(TestJpKeyboardManager_ComposeChar_Number)
		{
			KeyboardUtils::JpKeyboardManager manager;
			auto shifted = "!\"#$%&'()";
			for (int i = 0; i < 10; ++i) {
				auto actual = manager.ComposeChar('0' + i, FALSE);
				Assert::AreEqual('0' + i, (int) actual);

				actual = manager.ComposeChar('0' + i, TRUE);
				if (i == 0) {
					Assert::AreEqual(0x00, (int) actual);
				}
				else {
					Assert::AreEqual(shifted[i - 1], (char) actual);
				}
			}
		}

		TEST_METHOD(TestJpKeyboardManager_ComposeChar_Alphabet)
		{
			KeyboardUtils::JpKeyboardManager manager;
			for (int i = 0; i < 26; ++i) {
				auto actual = manager.ComposeChar('A' + i, FALSE);
				Assert::AreEqual('a' + i, (int) actual);
				actual = manager.ComposeChar('A' + i, TRUE);
				Assert::AreEqual('A' + i, (int) actual);
			}
		}

		TEST_METHOD(TestJpKeyboardManager_ComposeChar_Symbols)
		{
			KeyboardUtils::JpKeyboardManager manager;
			Assert::AreEqual(';', (char) manager.ComposeChar(0xBA, FALSE));
			Assert::AreEqual('^', (char) manager.ComposeChar(0xBB, FALSE));
			Assert::AreEqual(',', (char) manager.ComposeChar(0xBC, FALSE));
			Assert::AreEqual('-', (char) manager.ComposeChar(0xBD, FALSE));
			Assert::AreEqual('.', (char) manager.ComposeChar(0xBE, FALSE));
			Assert::AreEqual('/', (char) manager.ComposeChar(0xBF, FALSE));
			Assert::AreEqual(0x00, (int) manager.ComposeChar(0xC0, FALSE));
			Assert::AreEqual('@', (char) manager.ComposeChar(0xDB, FALSE));
			Assert::AreEqual(']', (char) manager.ComposeChar(0xDC, FALSE));
			Assert::AreEqual('[', (char) manager.ComposeChar(0xDD, FALSE));
			Assert::AreEqual(':', (char) manager.ComposeChar(0xDE, FALSE));
			Assert::AreEqual(0x5C, (int) manager.ComposeChar(0xFF, FALSE));

			Assert::AreEqual('+', (char) manager.ComposeChar(0xBA, TRUE));
			Assert::AreEqual('~', (char) manager.ComposeChar(0xBB, TRUE));
			Assert::AreEqual('<', (char) manager.ComposeChar(0xBC, TRUE));
			Assert::AreEqual('=', (char) manager.ComposeChar(0xBD, TRUE));
			Assert::AreEqual('>', (char) manager.ComposeChar(0xBE, TRUE));
			Assert::AreEqual('?', (char) manager.ComposeChar(0xBF, TRUE));
			Assert::AreEqual(0x00, (int) manager.ComposeChar(0xC0, TRUE));
			Assert::AreEqual('`', (char) manager.ComposeChar(0xDB, TRUE));
			Assert::AreEqual('}', (char) manager.ComposeChar(0xDC, TRUE));
			Assert::AreEqual('{', (char) manager.ComposeChar(0xDD, TRUE));
			Assert::AreEqual('*', (char) manager.ComposeChar(0xDE, TRUE));
			Assert::AreEqual('|', (char) manager.ComposeChar(0xFF, TRUE));
		}

		TEST_METHOD(TestUsKeyboardManager_Available_Number)
		{
			KeyboardUtils::UsKeyboardManager manager;
			for (int i = 0; i < 10; ++i) {
				auto actual = manager.Available('0' + i);
				Assert::IsTrue(TRUE);
			}
		}

		TEST_METHOD(TestUsKeyboardManager_Available_Alphabet)
		{
			KeyboardUtils::UsKeyboardManager manager;
			for (int i = 0; i < 26; ++i) {
				auto actual = manager.Available('A' + i);
				Assert::IsTrue(actual);
			}
		}

		TEST_METHOD(TestUsKeyboardManager_Available_Symbols)
		{
			KeyboardUtils::UsKeyboardManager manager;
			Assert::IsTrue(manager.Available(0xBA));
			Assert::IsTrue(manager.Available(0xBB));
			Assert::IsTrue(manager.Available(0xBC));
			Assert::IsTrue(manager.Available(0xBD));
			Assert::IsTrue(manager.Available(0xBE));
			Assert::IsTrue(manager.Available(0xBF));
			Assert::IsTrue(manager.Available(0xC0));
			Assert::IsTrue(manager.Available(0xDB));
			Assert::IsTrue(manager.Available(0xDC));
			Assert::IsTrue(manager.Available(0xDD));
			Assert::IsTrue(manager.Available(0xDE));
			Assert::IsFalse(manager.Available(0xFF));
		}

		TEST_METHOD(TestUsKeyboardManager_ComposeChar_Number)
		{
			KeyboardUtils::UsKeyboardManager manager;
			auto shifted = ")!@#$%^&*(";
			for (int i = 0; i < 10; ++i) {
				auto actual = manager.ComposeChar('0' + i, FALSE);
				Assert::AreEqual('0' + i, (int) actual);

				actual = manager.ComposeChar('0' + i, TRUE);
				Assert::AreEqual(shifted[i], (char) actual);
			}
		}

		TEST_METHOD(TestUsKeyboardManager_ComposeChar_Alphabet)
		{
			KeyboardUtils::UsKeyboardManager manager;
			for (int i = 0; i < 26; ++i) {
				auto actual = manager.ComposeChar('A' + i, FALSE);
				Assert::AreEqual('a' + i, (int) actual);
				actual = manager.ComposeChar('A' + i, TRUE);
				Assert::AreEqual('A' + i, (int) actual);
			}
		}

		TEST_METHOD(TestUsKeyboardManager_ComposeChar_Symbols)
		{
			KeyboardUtils::UsKeyboardManager manager;
			Assert::AreEqual('-', (char) manager.ComposeChar(0xBD, FALSE));
			Assert::AreEqual('=', (char) manager.ComposeChar(0xBB, FALSE));
			Assert::AreEqual(0x5C, (int) manager.ComposeChar(0xDC, FALSE));
			Assert::AreEqual('[', (char) manager.ComposeChar(0xDB, FALSE));
			Assert::AreEqual(']', (char) manager.ComposeChar(0xDD, FALSE));
			Assert::AreEqual(';', (char) manager.ComposeChar(0xBA, FALSE));
			Assert::AreEqual('\'', (char) manager.ComposeChar(0xDE, FALSE));
			Assert::AreEqual(',', (char) manager.ComposeChar(0xBC, FALSE));
			Assert::AreEqual('.', (char) manager.ComposeChar(0xBE, FALSE));
			Assert::AreEqual('/', (char) manager.ComposeChar(0xBF, FALSE));
			Assert::AreEqual('`', (char) manager.ComposeChar(0xC0, FALSE));

			Assert::AreEqual('_', (char) manager.ComposeChar(0xBD, TRUE));
			Assert::AreEqual('+', (char) manager.ComposeChar(0xBB, TRUE));
			Assert::AreEqual('|', (char) manager.ComposeChar(0xDC, TRUE));
			Assert::AreEqual('{', (char) manager.ComposeChar(0xDB, TRUE));
			Assert::AreEqual('}', (char) manager.ComposeChar(0xDD, TRUE));
			Assert::AreEqual(':', (char) manager.ComposeChar(0xBA, TRUE));
			Assert::AreEqual('\"', (char) manager.ComposeChar(0xDE, TRUE));
			Assert::AreEqual('<', (char) manager.ComposeChar(0xBC, TRUE));
			Assert::AreEqual('>', (char) manager.ComposeChar(0xBE, TRUE));
			Assert::AreEqual('?', (char) manager.ComposeChar(0xBF, TRUE));
			Assert::AreEqual('~', (char) manager.ComposeChar(0xC0, TRUE));
		}
	};
}
