#pragma once

#include "editsess.h"
#include "mark.h"

class CTerminateCompositionEditSession : public CEditSessionBase
{
public:
    CTerminateCompositionEditSession(CMarkTextService *pMark, ITfContext *pContext) : CEditSessionBase(pContext)
    {
        _pMark = pMark;
        _pMark->AddRef();
    }
    ~CTerminateCompositionEditSession()
    {
        _pMark->Release();
    }

    // ITfEditSession
    STDMETHODIMP DoEditSession(TfEditCookie ec)
    {
        _pMark->_TerminateComposition(ec);
        return S_OK;
    }

private:
    CMarkTextService *_pMark;
};

