#include <string>
#include <stdlib.h>
#include <vector>

std::string WStringToString ( std::wstring const &wstr )
{
    size_t size = 0;
    wcstombs_s ( &size, nullptr, 0, wstr.data(), _TRUNCATE );
    std::vector<char> buf ( size + 1 );
    wcstombs_s ( &size, buf.data(), buf.size(), wstr.data(), _TRUNCATE );
    return std::string ( buf.data() );
}


std::wstring StringToWString ( std::string const &str )
{
    size_t size = 0;
    mbstowcs_s ( &size, nullptr, 0, str.data(), _TRUNCATE );
    std::vector<wchar_t> buf ( size + 1 );
    mbstowcs_s ( &size, buf.data(), buf.size(), str.data(), _TRUNCATE );
    return std::wstring ( buf.data() );
}

// w肵؂蕶ŕ
void split(const std::wstring& s, const std::wstring& delim, std::vector<std::wstring>& result)
{
	result.clear();

	std::string::size_type pos = 0;

	while (pos != std::string::npos)
	{
		std::string::size_type p = s.find(delim, pos);

		if (p == std::string::npos)
		{
			result.push_back(s.substr(pos));
			break;
		}
		else {
			result.push_back(s.substr(pos, p - pos));
		}

		pos = p + delim.size();
	}
}
