#pragma once

#include "Observer.h"
#include "AkkharaActivateEvent.h"
#include "AkkharaDeactivateEvent.h"
#include "AkkharaMenuSelectEvent.h"
#include "AkkharaWindowCommandEvent.h"
#include "WindowSoftwareInformation.h"
#include "AkkharaMenuInitEvent.h"

namespace Observer {
	class SoftInfoWindowActivateObserver : public Observer {
	public:
		SoftInfoWindowActivateObserver(std::shared_ptr<GUI::CWindowSoftwareInformation> wndSoftInfo): wndSoftInfo_(wndSoftInfo){}

		virtual bool Notify(std::shared_ptr<Event::Message> message) {
			Event::AkkharaActivateMessage* m = (Event::AkkharaActivateMessage *) message.get();
			return wndSoftInfo_->Create(m->Parent(), m->WndProc(), m->HInstance()) == TRUE;
		}

	private:
		std::shared_ptr<GUI::CWindowSoftwareInformation> wndSoftInfo_;
	};

	class SoftInfoWindowMenuInitObserver : public Observer {
	public:
		SoftInfoWindowMenuInitObserver(std::shared_ptr<GUI::CWindowSoftwareInformation> wndSoftInfo): wndSoftInfo_(wndSoftInfo){}

		virtual bool Notify(std::shared_ptr<Event::Message> message) {
			Event::AkkharaMenuInitMessage* m = (Event::AkkharaMenuInitMessage *) message.get();
			std::size_t id = m->GetCallback()(SOFT_INFO_BUTTON_TITLE);
			wndSoftInfo_->SetButtonID(id);
			return true;
		}

	private:
		std::shared_ptr<GUI::CWindowSoftwareInformation> wndSoftInfo_;
	};

	class SoftInfoWindowMenuSelectObserver : public Observer {
	public:
		SoftInfoWindowMenuSelectObserver(std::shared_ptr<GUI::CWindowSoftwareInformation> wndSoftInfo): wndSoftInfo_(wndSoftInfo){}

		virtual bool Notify(std::shared_ptr<Event::Message> message) {
			Event::AkkharaMenuSelectMessage* m = (Event::AkkharaMenuSelectMessage*) message.get();

			if (m->ID() == wndSoftInfo_->GetButtonID()) {
				wndSoftInfo_->Show(TRUE);
			}
			return true;
		}

	private:
		std::shared_ptr<GUI::CWindowSoftwareInformation> wndSoftInfo_;
	};

	class SoftInfoWindowDeactivateObserver : public Observer {
	public:
		SoftInfoWindowDeactivateObserver(std::shared_ptr<GUI::CWindowSoftwareInformation> wndSoftInfo): wndSoftInfo_(wndSoftInfo){}

		virtual bool Notify(std::shared_ptr<Event::Message> message) {
			wndSoftInfo_->Destroy();
			return true;
		}

	private:
		std::shared_ptr<GUI::CWindowSoftwareInformation> wndSoftInfo_;
	};

	class SoftInfoWindowCommandObserver : public Observer {
	public:
		SoftInfoWindowCommandObserver(std::shared_ptr<GUI::CWindowSoftwareInformation> wndSoftInfo): wndSoftInfo_(wndSoftInfo){}

		virtual bool Notify(std::shared_ptr<Event::Message> message) {
			Event::AkkharaWindowCommandMessage* m = (Event::AkkharaWindowCommandMessage*) message.get();
			if (m->UMsg() == WM_COMMAND && LOWORD(m->WParam()) == BUTTON_ID_SOFT_INFO_CLOSE) {
				wndSoftInfo_->Show(FALSE);
			}
			return true;
		}

	private:
		std::shared_ptr<GUI::CWindowSoftwareInformation> wndSoftInfo_;
	};

	class SoftInfoWindowRegisterer: public Registerer
	{
	public:
		SoftInfoWindowRegisterer(): wndSoftInfo(new GUI::CWindowSoftwareInformation()){

		}

		virtual void Register(Subject* subject) {
			subject->AddObserver(std::shared_ptr<Event::Event>(new Event::AkkharaActivateEvent()), std::shared_ptr<Observer>(new SoftInfoWindowActivateObserver(wndSoftInfo)));
			subject->AddObserver(std::shared_ptr<Event::Event>(new Event::AkkharaMenuInitEvent()), std::shared_ptr<Observer>(new SoftInfoWindowMenuInitObserver(wndSoftInfo)));
			subject->AddObserver(std::shared_ptr<Event::Event>(new Event::AkkharaMenuSelectEvent()), std::shared_ptr<Observer>(new SoftInfoWindowMenuSelectObserver(wndSoftInfo)));
			subject->AddObserver(std::shared_ptr<Event::Event>(new Event::AkkharaDeactivateEvent()), std::shared_ptr<Observer>(new SoftInfoWindowDeactivateObserver(wndSoftInfo)));
			subject->AddObserver(std::shared_ptr<Event::Event>(new Event::AkkharaWindowCommandEvent()), std::shared_ptr<Observer>(new SoftInfoWindowCommandObserver(wndSoftInfo)));
		}


	private:
		std::shared_ptr<GUI::CWindowSoftwareInformation> wndSoftInfo;
	};
}

