#pragma once
#include "Event.h"
#include <memory>
#include "Message.h"

namespace Observer {
	class Observer;

	class Subject {
	public:
		virtual void AddObserver(std::shared_ptr<Event::Event> event, std::shared_ptr<Observer> observer) = 0;
	};

	class Observer
	{
	public:
		virtual bool Notify(std::shared_ptr<Event::Message> message) = 0;
	};


	class Registerer {
	public:
		virtual void Register(Subject *subject) = 0;
	};
}

