#include <windows.h>
#include <appmodel.h>
#include "Log.h"
#include "FolderUtil.h"
#include "uwp_util.h"
#include <stdexcept>


using namespace Windows::Storage;
using namespace Platform;

// Oɏo͂\[Xt@C
char g_szSrcFileName[MAX_PATH];
// Oɏo͂sԍ
int g_nLine = 0;


BOOL GetLogPath(char path[]) {
	// ϐAKKHARA_HOMEQƂA`Ă΃Oo͗LƂ݂ȂB
	size_t n;
	char userDir[AKKHARA_LOG_OUTPUT_FOLDER_MAX_LEN];
	if (getenv_s(&n, userDir, AKKHARA_LOG_OUTPUT_FOLDER_MAX_LEN, AKKHARA_ROOT_ENV_NAME) != 0) {
		throw std::runtime_error("Failed to load ENV");
	}
	if (n == 0) {
		return FALSE;
	}
	
	if (is_uwp()) {
		// ̖肪邽߁AUWPAvĂяoƂ̃Ot@C̓Aṽ[JXg[Wɏ
		// AKKHARA_HOMEɋLڂPATH͖
		// pX͒ʏ C:\Users\arrow\AppData\Local\Packages\Avi[tH_\LocalState ƂȂB
		std::wstring basePath(ApplicationData::Current->LocalFolder->Path->Data());
		std::wstring fileName(L"\\AkkharaInput.log");
		basePath = basePath + fileName;
		sprintf(path, "%ls", basePath.c_str());
		return TRUE;
	}

	// UWPAvȊȌꍇAAKKHARA_HOMEɋLڂꂽPATHɏoB
	sprintf(path, "%s/AkkharaInput.log", userDir);
	return TRUE;
}


// Ot@C̑݊mF
int ExistLogFile()
{
	char szLogFilePath[AKKHARA_LOG_OUTPUT_FOLDER_MAX_LEN];
	if (!GetLogPath(szLogFilePath)) {
		return -1;
	}


	struct stat st;

	if (stat(szLogFilePath, &st) != 0) {
		return -1;
	}

	return 0;
}

FILE* FileOpenSub()
{
	char szLogFilePath[AKKHARA_LOG_OUTPUT_FOLDER_MAX_LEN];
	if (!GetLogPath(szLogFilePath)) {
		throw std::runtime_error("log output is disabled");
	}


	// Ot@C̃TCYlȏ̏ꍇ͈U폜
	int fd;
	fd = _open(szLogFilePath, _O_RDONLY);
	if (fd != -1) {
		long fl = _filelength(fd);
		_close(fd);
		if (fl >= LOG_FILE_SIZE) {
			DeleteFile((LPCTSTR)szLogFilePath);
		}
	}

	return fopen(szLogFilePath, "at");
}

// Ot@CɎo
void OutputTime(FILE* fp)
{
#ifndef LOG_OUTPUT_TIME
	return;
#endif // LOG_OUTPUT_TIME
	// o
	SYSTEMTIME stNowL;
	// ݎ\:UTC
	GetLocalTime(&stNowL);

	char szTime[256];
	sprintf(szTime, "[%04d/%02d/%02d %02d:%02d:%02d.%03d]",
		stNowL.wYear, stNowL.wMonth, stNowL.wDay,
		stNowL.wHour, stNowL.wMinute, stNowL.wSecond, stNowL.wMilliseconds);
	// o
	fprintf(fp, "%s ", szTime);
}

// Ot@CɃt@CA\[X̍sԍo
void OutputInfo(FILE* fp)
{
	// \[Xt@Co
	if (strlen(g_szSrcFileName) > 0) {
		fprintf(fp, "(%s", g_szSrcFileName);
	}
	// Ώۂ̍sԍo
	if (g_nLine > 0) {
		fprintf(fp, "\tLine:%d)\t", g_nLine);
	}
}

// Ot@Cɏo
void Output(char* sMsg)
{
	FILE* fp = FileOpenSub();
	if (fp != NULL) {
		// Ot@CɎo
		OutputTime(fp);
		// Ot@CɃ\[Xt@CA\[X̍sԍo
		OutputInfo(fp);
		// bZ[Wo
		fprintf(fp, "%s", sMsg);
		fprintf(fp, "\n");
		fflush(fp);
		fclose(fp);
	}
}

// Ot@Cɏo
void OutputW(wchar_t* wsMsg)
{
	FILE* fp = FileOpenSub();
	if (fp != NULL) {
		// Ot@CɎo
		OutputTime(fp);
		// Ot@CɃ\[Xt@CA\[X̍sԍo
		OutputInfo(fp);
		// bZ[Wo
		fwprintf(fp, L"%s", wsMsg);
		fwprintf(fp, L"\n");
		fflush(fp);
		fclose(fp);
}
}

// Oo
void LogOutput(char *fmt, ...)
{
	// Ot@C̑݊mF
	// Ot@C݂Ȃꍇ͏܂Ȃ
	if (ExistLogFile() == -1) {
		return;
	}

	memset(g_szSrcFileName, 0, MAX_PATH);
	g_nLine = 0;

	char sData[1024];
	memset(sData, 0, 1024);
	va_list args;

	va_start (args, fmt);
	vsprintf (sData, fmt, args);
	va_end (args);
	// Ot@Cɏo
	Output(sData);
}

// Oo
void LogOutput(char* szSrcFileName, int nLine, char *fmt, ...)
{
	// Ot@C̑݊mF
	// Ot@C݂Ȃꍇ͏܂Ȃ
	if (ExistLogFile() == -1) {
		return;
	}

	char* pSrc = strrchr(szSrcFileName, '\\');
	if (pSrc != NULL) {
		pSrc++;
		strcpy(g_szSrcFileName, pSrc);
	}
	else {
		strcpy(g_szSrcFileName, szSrcFileName);
	}
	g_nLine = nLine;

	char sData[1024];
	memset(sData, 0, 1024);
	va_list args;

	va_start(args, fmt);
	vsprintf(sData, fmt, args);
	va_end(args);
	// Ot@Cɏo
	Output(sData);
}

// Oo
void LogOutputW(char* szSrcFileName, int nLine, wchar_t *fmt, ...)
{
	// Ot@C̑݊mF
	// Ot@C݂Ȃꍇ͏܂Ȃ
	if (ExistLogFile() == -1) {
		return;
	}

	char* pSrc = strrchr(szSrcFileName, '\\');
	if (pSrc != NULL) {
		pSrc++;
		strcpy(g_szSrcFileName, pSrc);
	}
	else {
		strcpy(g_szSrcFileName, szSrcFileName);
	}
	g_nLine = nLine;

	wchar_t sData[1024];
	memset(sData, 0, 1024);
	va_list args;

	va_start(args, fmt);
	vswprintf(sData, fmt, args);
	va_end(args);
	// Ot@Cɏo
	OutputW(sData);
}


// R[h̃OOt@Cɏo
void OutputCode(std::string head, std::wstring code)
{
	FILE* fp = FileOpenSub();
	if (fp != NULL) {
		// Ot@CɎo
		OutputTime(fp);
		// Ot@CɃ\[Xt@CA\[X̍sԍo
		OutputInfo(fp);
		// bZ[Wo
		fprintf(fp, "%s ", head.c_str());
		for (size_t i = 0; i < code.size(); i++)
		{
			fprintf(fp, "[0x%x] ", code[i]);
		}
		fprintf(fp, "\n");
		fflush(fp);
		fclose(fp);
	}
}

// R[h̃Oo
void LogOutputCode(char* szSrcFileName, int nLine, std::string head, std::wstring code)
{
	// Ot@C̑݊mF
	// Ot@C݂Ȃꍇ͏܂Ȃ
	if (ExistLogFile() == -1) {
		return;
	}

	char* pSrc = strrchr(szSrcFileName, '\\');
	if (pSrc != NULL) {
		pSrc++;
		strcpy(g_szSrcFileName, pSrc);
	}
	else {
		strcpy(g_szSrcFileName, szSrcFileName);
	}
	g_nLine = nLine;

	// Ot@Cɏo
	OutputCode(head, code);
}

// R[h̃Oo
void LogOutputCode(std::string head, std::wstring code)
{
	// Ot@C̑݊mF
	// Ot@C݂Ȃꍇ͏܂Ȃ
	if (ExistLogFile() == -1) {
		return;
	}

	// Ot@Cɏo
	OutputCode(head, code);
}

// R[h̃OOt@Cɏo
void OutputCode(std::string head, std::string code)
{
	FILE* fp = FileOpenSub();
	if (fp != NULL) {
		// Ot@CɎo
		OutputTime(fp);
		// Ot@CɃ\[Xt@CA\[X̍sԍo
		OutputInfo(fp);
		// bZ[Wo
		fprintf(fp, "%s ", head.c_str());
		for (size_t i = 0; i < code.size(); i++)
		{
			fprintf(fp, "[0x%x] ", code[i]);
		}
		fprintf(fp, "\n");
		fflush(fp);
		fclose(fp);
	}
}

// R[h̃Oo
void LogOutputCode(char* szSrcFileName, int nLine, std::string head, std::string code)
{
	// Ot@C̑݊mF
	// Ot@C݂Ȃꍇ͏܂Ȃ
	if (ExistLogFile() == -1) {
		return;
	}

	char* pSrc = strrchr(szSrcFileName, '\\');
	if (pSrc != NULL) {
		pSrc++;
		strcpy(g_szSrcFileName, pSrc);
	}
	else {
		strcpy(g_szSrcFileName, szSrcFileName);
	}
	g_nLine = nLine;

	// Ot@Cɏo
	OutputCode(head, code);
}

// R[h̃Oo
void LogOutputCode(std::string head, std::string code)
{
	// Ot@C̑݊mF
	// Ot@C݂Ȃꍇ͏܂Ȃ
	if (ExistLogFile() == -1) {
		return;
	}

	// Ot@Cɏo
	OutputCode(head, code);
}

// Ot@C폜
void DeleteLogFile()
{
	char szLogFilePath[AKKHARA_LOG_OUTPUT_FOLDER_MAX_LEN];
	if (!GetLogPath(szLogFilePath)) {
		throw std::runtime_error("log output is disabled");
	}
	DeleteFile((LPCTSTR)szLogFilePath);
}
