#include "LibreOfficeSupporter.h"
#include "CursorManagerUtils.h"
#include "Log.h"

TSF::CursorManagers::LibreOfficeSupporter::LibreOfficeSupporter() : count_(0) {}

bool TSF::CursorManagers::LibreOfficeSupporter::NotifyUpdate(ITfContextView* pContextView)
{
	// LibreOfficeɂĂ͈ʒu擾OWM_IME_NOTIFYIMN_OPENCANDIDATE𑗕t邱ƂňʒuPƂ̏񂪂
	// http://document-foundation-mail-archive.969070.n3.nabble.com/LibreOffice-IME-TSF-td4001403.html
	// ̂ȉɃRgAEgR[hALƁALibreOfficeŕ̓LbgĂ܂B
	// LĂ玞Ԃo߂Ă邽߁ALibreOffice̎ω\B
	/*
	HWND hWnd;
	if (pContextView->GetWnd(&hWnd) != S_OK) {
		return false;
	}

	auto hProc = GetWindowLongPtrW(hWnd, GWLP_WNDPROC);
	auto hr = CallWindowProcW((WNDPROC)hProc, hWnd, WM_IME_NOTIFY, IMN_OPENCANDIDATE, 1);
	if (!hr) {
		return false;
	}
	*/

	return true;
}

RECT TSF::CursorManagers::LibreOfficeSupporter::GetTextExt_(ITfContextView *pContextView, RECT prcByTSF)
{
	RECT prc = TSF::CursorManagers::GetCursorPositionWithoutTSF(pContextView, prcByTSF);
	RECT previous = GetTextExtFromCache();
	if (abs(prc.bottom - previous.bottom) <= 5 && count_ != 3) {
		prc = previous;
	}
	count_++;
	return prc;
}

void TSF::CursorManagers::LibreOfficeSupporter::Reset_()
{
	count_ = 0;
}
