#include "KeystrokeEditSession.h"
#include "globals.h"

//+---------------------------------------------------------------------------
//
// DoEditSession
//
//----------------------------------------------------------------------------

STDAPI CKeystrokeEditSession::DoEditSession(TfEditCookie ec)
{
	if (_pMark->IsInvalidComposition(_pContext, ec)) {
		ITfComposition *pComposition = NULL;
		if (GetCompositionFromContext(_pContext, ec, _pMark, &pComposition) == S_OK) {
			if (pComposition != NULL)
			{
				// LogOutput(__FUNCTION__, __LINE__, "Refresh pComposition");
				_pMark->_SetComposition(pComposition);
				_pMark->_SetCompositionDisplayAttributes(ec);
				pComposition->Release();
			}
			else {
				LogOutput(__FUNCTION__, __LINE__, "Refresh pComposition denied");
			}
		}
		else {
			LogOutput(__FUNCTION__, __LINE__, "Failed to get new pComposition");
		}
	}

	std::string keyInputs = { (char)((WCHAR)_wParam) };
	LogOutput(__FUNCTION__, __LINE__, "Press Key [%s][0x%04x]", keyInputs.c_str(), _wParam);
	HRESULT res = S_OK;
#ifdef LOG_OUTPUT_PROCTIME
	// L[̓X^[gۑ
	auto start = system_clock::now();
	auto end = system_clock::now();
#endif // LOG_OUTPUT_PROCTIME

	switch (_wParam)
    {
		// Xy[XL[
		case VK_SPACE:
			// ʃEChE̕NA
			_pMark->WorkerWindowClear(ec, _pContext);
			// 𐳋K
			res = _pMark->_HandleNormalization(ec, _pContext);
			break;

		// EnterL[
		case VK_RETURN:
			// ʃEChE̕NA
			_pMark->WorkerWindowClear(ec, _pContext);
			// ASCIÎ܂ܓ͂
			res = _pMark->_HandleAsciiInput(ec, _pContext);
			break;

		// BackspaceL[
		case VK_BACK:
			// 폜
			res = _pMark->_HandleBack(ec, _pContext);
			break;

		// ̑̃L[
		default:
			res = _pMark->_HandleKeyDownConvert(ec, _pContext, _wParam, with_shift);
			if (res == S_OK) {
				_pMark->_HandleSpace(ec, _pContext);
			}
			break;
	}
	return res;
}

