#pragma once
#include "editsess.h"
#include <string>
#include "globals.h"

class CInsertTextSession : public CEditSessionBase
{
public:
    CInsertTextSession(ITfContext *pContext, ITfComposition *pComposition, std::wstring text) 
        : CEditSessionBase(pContext), pComposition_(pComposition), text_(text)
    {}

    // ITfEditSession
    STDMETHODIMP DoEditSession(TfEditCookie ec) {
        return SetTextToComposition(ec, _pContext, pComposition_, text_);
    }

private:
    ITfContextView* pContextView_;
    ITfComposition* pComposition_;
    std::wstring text_;
};


