#include "ExcelSupporter.h"
#include "CursorManagerUtils.h"

TSF::CursorManagers::ExcelSupporter::ExcelSupporter() : count_(0) {}

RECT TSF::CursorManagers::ExcelSupporter::GetTextExt_(ITfContextView *pContextView, RECT prcByTSF)
{
	auto left = prcByTSF.left;
	auto prc = TSF::CursorManagers::GetCursorPositionWithoutTSF(pContextView, prcByTSF);
	RECT result = GetTextExtFromCache();
	if (count_ == 0 && left == prc.left) {
		result = prc;
	}
	else if (count_ == 1) {
		result = prc;
	}
	count_++;

	return result;
}

void TSF::CursorManagers::ExcelSupporter::Reset_()
{
	count_ = 0;
}
