#include <windows.h>
#include <windef.h>
#include <Psapi.h>
#include "CursorManagerUtils.h"

namespace TSF {
	namespace CursorManagers {
		std::wstring GetAppName(ITfContextView* pContextView) {
			HWND hwnd;
			if (pContextView->GetWnd(&hwnd) != S_OK) {
				return L"";
			}

			DWORD processId;
			GetWindowThreadProcessId(hwnd, &processId);
			HANDLE hProcess = OpenProcess(PROCESS_QUERY_INFORMATION | PROCESS_VM_READ, FALSE, processId);

			HMODULE hModule;
			DWORD cbNeeded;
			if (EnumProcessModules(hProcess, &hModule, sizeof(hModule), &cbNeeded) == 0) {
				CloseHandle(hProcess);
				return L"";
			}

			wchar_t appName[20];
			if (GetModuleBaseName(hProcess, hModule, appName, 20) == 0) {
				CloseHandle(hProcess);
				return L"";
			}
			return std::wstring(appName);
		}

		RECT GetCursorPositionWithoutTSF(ITfContextView* pContextView, RECT tsfPos) {
			HWND hwnd;
			if (pContextView->GetWnd(&hwnd) != S_OK) {
				return tsfPos;
			}
			auto current = ::GetCurrentThreadId();
			auto target = ::GetWindowThreadProcessId(hwnd, NULL);

			AttachThreadInput(current, target, TRUE);
			POINT ptCaret;
			BOOL stat = ::GetCaretPos(&ptCaret);
			ClientToScreen(hwnd, &ptCaret);
			tsfPos.right = ptCaret.x + (tsfPos.right - tsfPos.left + 1);
			tsfPos.left = ptCaret.x;
			tsfPos.bottom = ptCaret.y + (tsfPos.bottom - tsfPos.top + 1);
			tsfPos.top = ptCaret.y;
			AttachThreadInput(current, target, FALSE);
			return tsfPos;
		}
	}
}
