#pragma once
#include <msctf.h>
#include <string>
#include <memory>
#include "ApplicationSupporter.h"

namespace TSF {
	class CursorManager {
	public:
		CursorManager();

		RECT GetPRC(TfEditCookie ec, ITfComposition *pComposition);
		RECT GetPRC(TfEditCookie ec, ITfContextView *pContextView, ITfRange *pRange);
		RECT GetPRC(TfEditCookie ec, ITfContext *pContext, ITfContextView *pContextView);
		static bool IsUninitialized(RECT prc);
		bool RestartRequired();

		void ResetPRC(bool compositionEnd);

	private:
		bool DetectInfiniteLoop();
		RECT prc_;
		RECT prc_back_;
		std::size_t inf_count_;

		std::shared_ptr<CursorManagers::Supporter> supporter_;
	};
}
