#define NOMINMAX
#include <limits>
#include <windows.h>
#include "CursorManager.h"
#include "Log.h"
#include "uwp_util.h"
#include <psapi.h>
#include "NullSupporter.h"
#include "ExcelSupporter.h"
#include "LibreOfficeSupporter.h"
#include "CursorManagerUtils.h"


std::shared_ptr<TSF::CursorManagers::Supporter> GetSupporter(ITfContextView *pContextView) {
	auto app_name = TSF::CursorManagers::GetAppName(pContextView);
	// LogOutput(__FUNCTION__, __LINE__, "app_name = %ls", app_name.c_str());
	if (app_name == L"EXCEL.EXE") {
		LogOutput(__FUNCTION__, __LINE__, "Excel is detected");
		return std::shared_ptr<TSF::CursorManagers::Supporter>(new TSF::CursorManagers::ExcelSupporter());
	}else if(app_name == L"soffice.bin") {
		LogOutput(__FUNCTION__, __LINE__, "LibreOffice is detected");
		return std::shared_ptr<TSF::CursorManagers::Supporter>(new TSF::CursorManagers::LibreOfficeSupporter());
	}
	return std::shared_ptr<TSF::CursorManagers::Supporter>(new TSF::CursorManagers::NullSupporter());
}


TSF::CursorManager::CursorManager() : supporter_(nullptr)
{
	ResetPRC(true);
}

bool TSF::CursorManager::DetectInfiniteLoop() {
	// ꕔ̃AvP[VTSFAPǏĂяogK[ɂOnLayoutChangeĂяoƂmFĂB
	// ̃AvP[VłOnLayoutChangeɂWindowoʒuĎ擾ƁA[vB
	// ŁA10AʒuꂽƂOnLayoutChange[vɓƉ肵ATSFAPIĂяo~߂
	// (5ڒxňʒuς邱Ƃ邽߈SlɂĂ)
	// ́Aߋ̍Ŵ܂ܕԂƂTSF̌Ăяo邱Ƃł̖B
	// ȂAprc_ ̒lCompositionIɃZbg邽߁AxifsꂽƌĉiTSFĂяo~܂邱Ƃ͂ȂB
	if (IsUninitialized(prc_)) {
		return false;
	}
	if (prc_.left == prc_back_.left && prc_.bottom == prc_back_.bottom) {
		inf_count_++;
	}
	else {
		inf_count_ = 0;
	}
	return inf_count_ >= 10;
}

RECT TSF::CursorManager::GetPRC(TfEditCookie ec, ITfComposition* pComposition){
	if (DetectInfiniteLoop()) {
		return supporter_->GetTextExtFromCache();
	}

	ITfRange* pRange;
	if (pComposition->GetRange(&pRange) != NULL) {
		LogOutput(__FUNCTION__, __LINE__, "FAILED TO CALL GetRange");
		return prc_;
	}

	ITfContext* pContext;
	if (pRange->GetContext(&pContext) != S_OK) {
		LogOutput(__FUNCTION__, __LINE__, "FAILED TO CALL GetContext");
		pRange->Release();
		return prc_;
	}

	ITfContextView *pContextView;
	if (pContext->GetActiveView(&pContextView) != S_OK) {
		LogOutput(__FUNCTION__, __LINE__, "FAILED TO CALL GetActiveView");
		pRange->Release();
		pContext->Release();
		return prc_;
	}

	auto prc = GetPRC(ec, pContextView, pRange);
	pContext->Release();
	pRange->Release();
	pContextView->Release();
	return prc;
}

RECT TSF::CursorManager::GetPRC(TfEditCookie ec, ITfContext *pContext, ITfContextView* pContextView){
	if (DetectInfiniteLoop()) {
		return supporter_->GetTextExtFromCache();
	}

	TF_SELECTION tfSelection;
	ULONG cFetched;
	if (pContext->GetSelection(ec, TF_DEFAULT_SELECTION, 1, &tfSelection, &cFetched) != S_OK || cFetched != 1) {
        return prc_;
	}
	auto prc = GetPRC(ec, pContextView, tfSelection.range);
	tfSelection.range->Release();
	return prc;
}

RECT TSF::CursorManager::GetPRC(TfEditCookie ec, ITfContextView* pContextView, ITfRange* pRange)
{
	if (!supporter_) {
		supporter_ = GetSupporter(pContextView);
	}
	supporter_->NotifyUpdate(pContextView);

	RECT prc;
	BOOL pfClipped;
	HRESULT stat = pContextView->GetTextExt(ec, pRange, &prc, &pfClipped);
	if (stat != S_OK) {
		switch (stat) {
		case TS_E_INVALIDPOS:
			LogOutput(__FUNCTION__, __LINE__, "FAILED TO CALL GetTextExt TS_E_INVALIDPOS");
			break;
		case TS_E_NOLAYOUT:
			// uEUɂĂ܂ TS_E_NOLAYOUTĂяo邪A܂ɌĂяoꂸɏꏊ߂邱ƂB
			LogOutput(__FUNCTION__, __LINE__, "FAILED TO CALL GetTextExt TS_E_NOLAYOUT");
			break;
		case TS_E_NOLOCK:
			LogOutput(__FUNCTION__, __LINE__, "FAILED TO CALL GetTextExt TS_E_NOLOCK");
			break;
		default:
			LogOutput(__FUNCTION__, __LINE__, "FAILED TO CALL GetTextExt unknown[%x]", stat);
			break;
		}
		ResetPRC(true);
		return prc_;
	}

	// LogOutput(__FUNCTION__, __LINE__, "Client prc [left=%d, right=%d, top=%d, bottom=%d]", prc.left, prc.right, prc.top, prc.bottom);

	// AvƂ̓ꏈKvȏꍇ͏㏑
	prc = supporter_->GetTextExt(pContextView, prc);

	// [vopɉߋ2񕪂̍WTĂ
	prc_back_ = prc_;
	prc_ = prc;

	return prc;
}

bool TSF::CursorManager::IsUninitialized(RECT prc) {
	return prc.top == std::numeric_limits<long>::max() || prc.left == std::numeric_limits<long>::max();
}

void TSF::CursorManager::ResetPRC(bool compositionEnd) {
	prc_.top = std::numeric_limits<long>::max();
	prc_.left= std::numeric_limits<long>::max();
	prc_.bottom = std::numeric_limits<long>::max();
	prc_.right = std::numeric_limits<long>::max();
	prc_back_ = prc_;
	if (compositionEnd && supporter_) {
		supporter_->Reset();
		inf_count_ = 0;
	}
}

bool TSF::CursorManager::RestartRequired() {
	if (supporter_) {
		return supporter_->RestartRequired();
	}
	return false;
}
