#pragma once
#include "Observer.h"
#include "AkkharaActivateEvent.h"
#include "AkkharaDeactivateEvent.h"
#include "AkkharaMenuInitEvent.h"
#include "AkkharaMenuSelectEvent.h"
#include "AkkharaWindowCommandEvent.h"
#include "WindowConversionRule.h"

namespace Observer {
	class ConversionRuleWindowActivateObserver : public Observer {
	public:
		ConversionRuleWindowActivateObserver(std::shared_ptr<GUI::CWindowConversionRule> wndCnvRule): wndCnvRule_(wndCnvRule){}

		virtual bool Notify(std::shared_ptr<Event::Message> message) {
			Event::AkkharaActivateMessage* m = (Event::AkkharaActivateMessage *) message.get();
			return wndCnvRule_->Create(m->Parent(), m->WndProc(), m->HInstance()) == TRUE;
		}

	private:
		std::shared_ptr<GUI::CWindowConversionRule> wndCnvRule_;
	};

	class ConversionRuleWindowMenuInitObserver : public Observer {
	public:
		ConversionRuleWindowMenuInitObserver(std::shared_ptr<GUI::CWindowConversionRule> wndCnvRule): wndCnvRule_(wndCnvRule){}

		virtual bool Notify(std::shared_ptr<Event::Message> message) {
			Event::AkkharaMenuInitMessage* m = (Event::AkkharaMenuInitMessage *) message.get();
			std::size_t id = m->GetCallback()(CONV_RULE_BUTTON_TITLE);
			wndCnvRule_->SetButtonID(id);
			return true;
		}

	private:
		std::shared_ptr<GUI::CWindowConversionRule> wndCnvRule_;
	};


	class ConversionRuleWindowMenuSelectObserver : public Observer {
	public:
		ConversionRuleWindowMenuSelectObserver(std::shared_ptr<GUI::CWindowConversionRule> wndCnvRule): wndCnvRule_(wndCnvRule){}

		virtual bool Notify(std::shared_ptr<Event::Message> message) {
			Event::AkkharaMenuSelectMessage* m = (Event::AkkharaMenuSelectMessage*) message.get();

			if (m->ID() != wndCnvRule_->GetButtonID()) {
				return true;
			}
			auto lang = m->Compositor()->GetCurrentLanguage();
			wndCnvRule_->SetTextLanguage(lang.Name());
			wndCnvRule_->SetAkkhara(m->Compositor()->Table());
			wndCnvRule_->Show(TRUE);
			return true;
		}

	private:
		std::shared_ptr<GUI::CWindowConversionRule> wndCnvRule_;
	};

	class ConversionRuleWindowDeactivateObserver : public Observer {
	public:
		ConversionRuleWindowDeactivateObserver(std::shared_ptr<GUI::CWindowConversionRule> wndCnvRule): wndCnvRule_(wndCnvRule){}

		virtual bool Notify(std::shared_ptr<Event::Message> message) {
			wndCnvRule_->Destroy();
			return true;
		}

	private:
		std::shared_ptr<GUI::CWindowConversionRule> wndCnvRule_;
	};

	class ConversionRuleWindowCommandObserver : public Observer {
	public:
		ConversionRuleWindowCommandObserver(std::shared_ptr<GUI::CWindowConversionRule> wndCnvRule): wndCnvRule_(wndCnvRule){}

		virtual bool Notify(std::shared_ptr<Event::Message> message) {
			Event::AkkharaWindowCommandMessage* m = (Event::AkkharaWindowCommandMessage*) message.get();
			if (m->UMsg() == WM_COMMAND && LOWORD(m->WParam()) == BUTTON_ID_CONVERSION_RULE_CLOSE) {
				wndCnvRule_->ConversionRuleUpdate();
				wndCnvRule_->Show(FALSE);
				m->Compositor()->SaveRules();
			}
			else if (LOWORD(m->WParam()) == TUB_ID_CONVERSION_RULE) {
				wndCnvRule_->ChangeTab();
			}
			return true;
		}

	private:
		std::shared_ptr<GUI::CWindowConversionRule> wndCnvRule_;
	};

	class ConversionRuleWindowRegisterer: public Registerer
	{
	public:
		ConversionRuleWindowRegisterer(): wndCnvRule(new GUI::CWindowConversionRule()){}

		virtual void Register(Subject* subject) {
			subject->AddObserver(std::shared_ptr<Event::Event>(new Event::AkkharaActivateEvent()), std::shared_ptr<Observer>(new ConversionRuleWindowActivateObserver(wndCnvRule)));
			subject->AddObserver(std::shared_ptr<Event::Event>(new Event::AkkharaMenuInitEvent()), std::shared_ptr<Observer>(new ConversionRuleWindowMenuInitObserver(wndCnvRule)));
			subject->AddObserver(std::shared_ptr<Event::Event>(new Event::AkkharaMenuSelectEvent()), std::shared_ptr<Observer>(new ConversionRuleWindowMenuSelectObserver(wndCnvRule)));
			subject->AddObserver(std::shared_ptr<Event::Event>(new Event::AkkharaDeactivateEvent()), std::shared_ptr<Observer>(new ConversionRuleWindowDeactivateObserver(wndCnvRule)));
			subject->AddObserver(std::shared_ptr<Event::Event>(new Event::AkkharaWindowCommandEvent()), std::shared_ptr<Observer>(new ConversionRuleWindowCommandObserver(wndCnvRule)));
		}


	private:
		std::shared_ptr<GUI::CWindowConversionRule> wndCnvRule;
	};
}

