#pragma once
#include "AkkharaComposition.h"
#include "AkkharaConversionTable.h"

namespace Composition {

	class Language 
	{
	public:
		Language(UINT id, std::wstring name): id_(id), name_(name) {}
		Language(const Language& other) : id_(other.id_), name_(other.name_) {}

		const std::wstring Name() const {
			return name_;
		}

		UINT ID() const {
			return id_;
		}

	private:
		std::wstring name_;
		UINT id_;
	};

	class Compositor
	{
	public:
		Compositor();
		void Switch(UINT langID);

		const Language GetCurrentLanguage() const {
			return Language(currentLangID_, table_.GetCurrentLanguageName());
		}

		std::vector<Language> Languages() const {
			std::vector<Language> languages;
			auto language_names = table_.GetLanguageList();
			int id = 0;
			for (std::wstring name : language_names) {
				languages.push_back(Language(id, name));
				id++;
			}
			return languages;
		}

		[[deprecated]]
		CAkkharaConversionTable* Table() {
			return &table_;
		}

		void SaveRules() {
			table_.WriteAkkharaFile();
			composition_.SetAkkharaConversionTable(&table_);
		}

		// Thin wrapper functions
		
		UINT WordLength() const {
			return composition_.GetWordLen();
		}

		std::wstring Normalize() {
			return composition_.Normalization();
		}

		std::wstring GetInputKeys() {
			return composition_.GetKeyInputStr();
		}

		void Delete(std::wstring &input, std::wstring &words) {
			composition_.Delete(input, words);
		}

		BOOL AddKey(WCHAR ch) {
			return composition_.AddInputKey(ch);
		}

		std::wstring Convert() {
			return composition_.GetConvertAkkharaWord();
		}

		void Reset() {
			composition_.Reset();
		}

	private:
		CAkkharaComposition composition_;
		CAkkharaConversionTable table_;
		UINT currentLangID_;
	};
}

