#include "CompositionEditSession.h"

//+---------------------------------------------------------------------------
//
// DoEditSession
//
//----------------------------------------------------------------------------

STDAPI CCompositionEditSession::DoEditSession(TfEditCookie ec)
{
    HRESULT hr;
    BOOL fEqualContexts;

    hr = E_FAIL;

    if (_pMark->_IsComposing())
    {
        // we have a composition, let's terminate it
        
        // it's possible our current composition is in another context...let's find out
        fEqualContexts = TRUE;
        ITfRange *pRangeComposition;
        if (_pMark->_GetComposition()->GetRange(&pRangeComposition) == S_OK)
        {
            ITfContext *pCompositionContext;
            if (pRangeComposition->GetContext(&pCompositionContext) == S_OK)
            {
                fEqualContexts = IsEqualUnknown(pCompositionContext, _pContext);
                if (!fEqualContexts)
                {
                    // need an edit session in the composition context
                    _pMark->_TerminateCompositionInContext(pCompositionContext);
                }
                pCompositionContext->Release();
            }
            pRangeComposition->Release();
        }

        // if the composition is in pContext, we already have an edit cookie
        if (fEqualContexts)
        {
            _pMark->_TerminateComposition(ec);
        }
    }
    else
    {
        // let's start a new composition over the current selection
        // this is totally contrived, a real text service would have
        // some meaningful logic to trigger this

        ITfComposition *pComposition = NULL;
        if (GetCompositionFromContext(_pContext, ec, _pMark, &pComposition) != S_OK) {
            goto Exit;
        }

        // _pComposition may be NULL even if StartComposition return S_OK, this mean the application
        // rejected the composition
		if (pComposition != NULL)
        {
            // IԂœ͊JnRangeɕ񂪓ĂB
            // I𒆂ȂeNAB
			ITfRange *pRangeComposition = NULL;
			pComposition->GetRange(&pRangeComposition);
			if (pRangeComposition != NULL) {
                SetTextToComposition(ec, _pContext, pComposition, L"");
                pRangeComposition->Release();
			}

			_pMark->_SetComposition(pComposition);
            // underline the composition text to give the user some feedback UI
            _pMark->_SetCompositionDisplayAttributes(ec);
            pComposition->Release();
        }
    }

    // if we make it here, we've succeeded
    hr = S_OK;

Exit:
    return hr;
}

