#pragma once
#include "Message.h"
#include <memory>
#include <minwindef.h>
#include <WinUser.h>
#include "Compositor.h"

namespace Event {
	class AkkharaWindowCommandEvent : public Event {
	public:
		AkkharaWindowCommandEvent(){}

		virtual std::string GetName() {
			return Name();
		}

		static std::string Name() {
			return "AkkharaWindowCommandEvent";
		}
	};

	class AkkharaWindowCommandMessage: public Message
	{
	public:
		AkkharaWindowCommandMessage(UINT uMsg, WPARAM wParam, Composition::Compositor *compositor): uMsg_(uMsg), wParam_(wParam), compositor_(compositor) {}

		virtual std::shared_ptr<Event> EventType() {
			return std::shared_ptr<Event>(new AkkharaWindowCommandEvent());
		}

		WPARAM WParam() { return wParam_; }
		UINT UMsg() { return uMsg_; }
		Composition::Compositor* Compositor() { return compositor_; }

	private:
		UINT uMsg_;
		WPARAM wParam_;
		Composition::Compositor *compositor_;
	};
}

