#pragma once
#include "Message.h"
#include <memory>
#include <minwindef.h>
#include <WinUser.h>
#include "Compositor.h"

namespace Event {
	class AkkharaMenuSelectEvent : public Event {
	public:
		AkkharaMenuSelectEvent(){}

		virtual std::string GetName() {
			return Name();
		}

		static std::string Name() {
			return "AkkharaMenuSelect";
		}
	};

	class AkkharaMenuSelectMessage: public Message
	{
	public:
		AkkharaMenuSelectMessage(std::uint32_t id, Composition::Compositor *compositor): id_(id), compositor_(compositor) {}

		virtual std::shared_ptr<Event> EventType() {
			return std::shared_ptr<Event>(new AkkharaMenuSelectEvent());
		}

		std::uint32_t ID() { return id_; }
		Composition::Compositor* Compositor() { return compositor_; }

	private:
		std::uint32_t id_;
		Composition::Compositor *compositor_;
	};
}
