#pragma once
#include <memory>
#include <functional>
#include "Message.h"
#include <minwindef.h>
#include <WinUser.h>
#include "Compositor.h"

namespace Event {
	class AkkharaMenuInitEvent : public Event {
	public:
		AkkharaMenuInitEvent(){}

		virtual std::string GetName() {
			return Name();
		}

		static std::string Name() {
			return "AkkharaMenuInit";
		}
	};

	class AkkharaMenuInitMessage: public Message
	{
	public:
		AkkharaMenuInitMessage(
			std::function<std::size_t(std::wstring)> callback
		): callback_(std::move(callback)) {}

		virtual std::shared_ptr<Event> EventType() {
			return std::shared_ptr<Event>(new AkkharaMenuInitEvent());
		}

		std::function<std::size_t(std::wstring)> GetCallback() {
			return callback_;
		}

	private:
		std::function<std::size_t(std::wstring)> callback_;

	};
}

