#pragma once
#ifndef _AKKHARA_CONVERSION_TABLE_H
#define _AKKHARA_CONVERSION_TABLE_H
#include <string>
#include <vector>
#include "StringUtil.h"
#include "Log.h"


///////////////////////////////////////////////////////////
// CAkkharaConversionDataNX
// AKKHARAϊNX
///////////////////////////////////////////////////////////
class CAkkharaConversionData
{
private:
	// ϊt@CJ
	enum ColumnKind {
		// ϊO
		BEFORE = 0,
		// ϊ㕶
		AFTER,
		// ϊ
		ORDER,
		// pґI/s̃tO
		USE_FLAG,
	};

	// L[͕
	char keyCode;
	// ϊOi\pj
	std::vector<std::wstring> beforeWordsShow;
	// ϊOiϊpj
	std::vector<std::wstring> beforeWords;
	// ϊ㕶i\pj
	std::vector<std::wstring> afterWordsShow;
	// ϊ㕶iϊpj
	std::vector<std::wstring> afterWords;
	// ϊ
	int order;
	// pґI/s̃tO
	int use_flag;

public:
	// RXgN^
	CAkkharaConversionData();
	// fXgN^
	virtual ~CAkkharaConversionData();
	// f[^Zbg
	BOOL SetData(wchar_t* buffer);
	// L[͕擾
	char GetKeyCode();
	// ϊOi\pj擾
	std::vector<std::wstring> GetBeforeWordsShow();
	// ϊOiϊpj擾
	std::vector<std::wstring> GetBeforeWords();
	// ϊ㕶i\pj擾
	std::vector<std::wstring> GetAfterWordsShow();
	// ϊ㕶iϊpj擾
	std::vector<std::wstring> GetAfterWords();
	// ϊ擾
	int GetOrder();
	// pґI/s̃tO擾
	int GetUseFlag();
	// pґI/s̃tOZbg
	void SetUseFlag(int flag);
	// fobOpOo
	void DebugLog();
};

///////////////////////////////////////////////////////////
// CAkkharaConversionOrderNX
// AKKHARAϊNXXgێ
///////////////////////////////////////////////////////////
class CAkkharaConversionOrder
{
private:
	// AKKHARAϊNXXg
	std::vector<CAkkharaConversionData> conversion;

public:
	// RXgN^
	CAkkharaConversionOrder();
	// fXgN^
	virtual ~CAkkharaConversionOrder();
	// AKKHARAϊNXǉ
	void AddConversion(CAkkharaConversionData akkConv);
	// AKKHARAϊNXXg擾
	size_t GetConversionNum();
	// AKKHARAϊNX擾
	CAkkharaConversionData GetConversion(int index);
	// pґI/s̃tOXV
	void UpdateUseFlag(int index, int flag);
};


///////////////////////////////////////////////////////////
// CAkkharaConversionTableNX
// AKKHARAϊe[uNX
///////////////////////////////////////////////////////////
class CAkkharaConversionTable
{
private:
	// ꃊXg
	std::vector<std::wstring> vecwstrLanguageList;
	// AKKHARAt@CpXXg
	std::vector<std::wstring> vecwstrAkkharaFilePath;
	// L[͂AKKHARAϊNXXg
	std::vector<CAkkharaConversionData> keyInput;
	// AKKHARAϊNXXg
	std::vector<CAkkharaConversionOrder> conversionOrder;
	// KAKKHARAϊNXXg
	std::vector<CAkkharaConversionData> normalization;
	// Jg̑ICfbNX
	int m_nCurSelected;

private:
	// AKKHARAt@C̃tH[}bg擾
	std::wstring GetAkkharaStr(CAkkharaConversionData akkhara);

public:
	// RXgN^
	CAkkharaConversionTable();
	// fXgN^
	virtual ~CAkkharaConversionTable();
	// AKKHARAt@C
	BOOL SeekAkkharaFile();
	// ꃊXg擾
	std::vector<std::wstring> GetLanguageList() const;
	// Jǧꖼ擾
	std::wstring GetCurrentLanguageName() const;
	// ϊe[u̐
	BOOL CreateConvertTable(int index);
	// AKKHARAt@C̏
	BOOL WriteAkkharaFile();
	// L[͂AKKHARAϊNXXg擾
	size_t GetKeyInputNum();
	// Xg擾
	size_t GetConversionOrdersNum();
	// AKKHARAϊNXXg擾
	size_t GetConversionNum(int order);
	// KAKKHARAϊNXXg擾
	size_t GetNormalizationNum();
	// L[͂AKKHARAϊNX擾
	CAkkharaConversionData GetKeyInput(int index);
	// w肳ꂽcharɑ΂镶KeyInputɑ݂邩ׁA݂ꍇ͊YConversionDataԂ
	CAkkharaConversionData *LookupKeyInput(const char c);

	// AKKHARAϊNX擾
	CAkkharaConversionData GetConversion(int order, int index);
	// KAKKHARAϊNX擾
	CAkkharaConversionData GetNormalization(int index);
	// pґI/s̃tOXV
	void UpdateUseFlag(int order, int index, int flag);
	// fobOpOo
	void DebugLog();
};
#endif // _AKKHARA_CONVERSION_TABLE_H
