#pragma once

#ifndef _AKKHARA_COMPOSITION_H
#define _AKKHARA_COMPOSITION_H

#include <string>
#include <vector>
#include "AkkharaConversionTable.h"
#include "Log.h"


///////////////////////////////////
// AKKHARAϊێNX
///////////////////////////////////
class CAkkharaInputHistory
{
private:
	// ͕R[hz
	std::vector<std::wstring> vwstrCharCode;
	// ϊOR[hz
	std::vector<std::wstring> vwBeforeCharCodes;
	// ϊ㕶R[hz
	std::vector<std::wstring> vwAfterCharCodes;

public:
	// RXgN^
	CAkkharaInputHistory();
	// fXgN^
	virtual ~CAkkharaInputHistory();
	// ͕R[hzݒ肷
	void SetCharCode(std::vector<std::wstring> codes);
	// ͕R[hz擾
	std::vector<std::wstring> GetCharCode();
	// ϊOR[hzݒ肷
	void SetBeforeCharCodes(std::vector<std::wstring> codes);
	// ϊOR[hz擾
	std::vector<std::wstring> GetBeforeCharCodes();
	// ϊ㕶R[hzݒ肷
	void SetAfterCharCodes(std::vector<std::wstring> codes);
	// ϊ㕶R[hz擾
	std::vector<std::wstring> GetAfterCharCodes();
	// fobOpOo
	void DebugLog();
};

///////////////////////////////////
// AKKHARAgݗăNX
///////////////////////////////////
class CAkkharaComposition
{
private:
	// L[͕
	std::string m_strKeyInput;
	// ێpϊR[hz
	std::vector<std::wstring> m_vwCharCodeInternal;
	// ϊ
	std::wstring m_wstrConvWords;
	// ̓^Cv
	enum InputType {
		// 
		NORMAL = 0,
		// 啶
		CAPITAL
	};
	// AKKHARAϊe[uNX
	CAkkharaConversionTable* m_pAkkhara;
	// ͗z
	std::vector<CAkkharaInputHistory> m_vakkharaInputHistory;

public:
	// RXgN^
	CAkkharaComposition();
	// fXgN^
	virtual ~CAkkharaComposition();
	// AKKHARAϊe[uNXZbg
	void SetAkkharaConversionTable(CAkkharaConversionTable* pAkkhara);
	// ϊΏۂ̓̓L[ǉ
	BOOL AddInputKey(WCHAR wParamKey);
	// Zbg
	void Reset();
	// ݂͕̓擾
	std::wstring GetKeyInputStr();
	// ϊ擾
	std::wstring GetConvertAkkharaWord();
	// ݂̕擾
	int GetWordLen() const;
	// ͕Aϊ폜
	void Delete(std::wstring& input, std::wstring& word);
	// ̐K
	std::wstring Normalization();
};

#endif // _AKKHARA_COMPOSITION_H
