#include "AkkharaComposition.h"
#include "StringUtil.h"


///////////////////////////////////
// AKKHARAϊێNX
///////////////////////////////////
// RXgN^
CAkkharaInputHistory::CAkkharaInputHistory()
{
}

// fXgN^
CAkkharaInputHistory::~CAkkharaInputHistory()
{
}

// ͕R[hݒ肷
void CAkkharaInputHistory::SetCharCode(std::vector<std::wstring> codes)
{
	vwstrCharCode = codes;
}

// ͕R[h擾
std::vector<std::wstring> CAkkharaInputHistory::GetCharCode()
{
	return vwstrCharCode;
}

// ϊOR[hzݒ肷
void CAkkharaInputHistory::SetBeforeCharCodes(std::vector<std::wstring> codes)
{
	vwBeforeCharCodes = codes;
}

// ϊOR[hz擾
std::vector<std::wstring> CAkkharaInputHistory::GetBeforeCharCodes()
{
	return vwBeforeCharCodes;
}

// ϊ㕶R[hzݒ肷
void CAkkharaInputHistory::SetAfterCharCodes(std::vector<std::wstring> codes)
{
	vwAfterCharCodes = codes;
}

// ϊ㕶R[hz擾
std::vector<std::wstring> CAkkharaInputHistory::GetAfterCharCodes()
{
	return vwAfterCharCodes;
}

// fobOpOo
void CAkkharaInputHistory::DebugLog()
{
	std::string sData = "";
	char sTmp[1024];
	std::wstring wstr;

	sData = "code[ ";
	for (size_t i = 0; i < vwstrCharCode.size(); i++) {
		wstr = vwstrCharCode[i];
		for (size_t j = 0; j < wstr.size(); j++) {
			sprintf(sTmp, "0x%x ", wstr[j]);
			sData += sTmp;
		}
	}
	sData += "] before[ ";
	for (size_t i = 0; i < vwBeforeCharCodes.size(); i++) {
		wstr = vwBeforeCharCodes[i];
		for (size_t j = 0; j < wstr.size(); j++) {
			sprintf(sTmp, "0x%x ", wstr[j]);
			sData += sTmp;
		}
	}
	sData += "] after[ ";
	for (size_t i = 0; i < vwAfterCharCodes.size(); i++) {
		wstr = vwAfterCharCodes[i];
		for (size_t j = 0; j < wstr.size(); j++) {
			sprintf(sTmp, "0x%x ", wstr[j]);
			sData += sTmp;
		}
	}
	sData += "]";

	LogOutput(__FUNCTION__, __LINE__, "history %s", sData.c_str());
}

///////////////////////////////////
// AKKHARAgݗăNX
///////////////////////////////////

// RXgN^
CAkkharaComposition::CAkkharaComposition()
{
	m_strKeyInput = "";
#ifdef MYANMAR_INPUT
	buffer = L"";
#endif // MYANMAR_INPUT
	m_wstrConvWords = L"";
	m_pAkkhara = NULL;
	m_vwCharCodeInternal.clear();
	m_vakkharaInputHistory.clear();
}

// fXgN^
CAkkharaComposition::~CAkkharaComposition()
{
	m_vwCharCodeInternal.clear();
	m_vakkharaInputHistory.clear();
}

// AKKHARAϊe[uNXZbg
void CAkkharaComposition::SetAkkharaConversionTable(CAkkharaConversionTable* pAkkhara)
{
	m_pAkkhara = pAkkhara;
}

// ϊΏۂ̓̓L[ǉ
BOOL CAkkharaComposition::AddInputKey(WCHAR targetKey)
{
	std::string input = { (char)targetKey };
	LogOutput(__FUNCTION__, __LINE__, "Target Key [%s][0x%04x]", input.c_str(), targetKey);

	if (m_pAkkhara->LookupKeyInput((char)targetKey) == NULL) {
		return FALSE;
	}

	m_strKeyInput += input;
	LogOutput(__FUNCTION__, __LINE__, "m_strKeyInput [%s]", m_strKeyInput.c_str());

	return TRUE;
}

// ݂̕擾
int CAkkharaComposition::GetWordLen() const
{
	return m_wstrConvWords.size();
}

// Zbg
void CAkkharaComposition::Reset()
{
	m_strKeyInput = "";
	m_wstrConvWords = L"";
	m_vwCharCodeInternal.clear();
	m_vakkharaInputHistory.clear();
}

// ݂͕̓擾
std::wstring CAkkharaComposition::GetKeyInputStr()
{
	LogOutputW(__FUNCTION__, __LINE__, L"wide [%s]", StringToWString(m_strKeyInput).c_str());
	return StringToWString(m_strKeyInput);
}

// ϊ擾
std::wstring CAkkharaComposition::GetConvertAkkharaWord()
{
	CAkkharaInputHistory akkharaInputHistory;

	// L[͂̕ϊ
	auto convData = m_pAkkhara->LookupKeyInput(m_strKeyInput[m_strKeyInput.size() - 1]);

	if (convData != NULL) {
		char keyCode = convData->GetKeyCode();
		LogOutput(__FUNCTION__, __LINE__, "keyCode[%c][0x%x]", keyCode, keyCode);
		std::vector<std::wstring> afterWords = convData->GetAfterWords();
		for (size_t after = 0; after < afterWords.size(); after++) {
			// eLXgo
			m_wstrConvWords += afterWords[after];
			m_vwCharCodeInternal.push_back(afterWords[after]);
		}
		// 폜pɓ͗ێ
		akkharaInputHistory.SetCharCode(afterWords);
	}

	// ̕ϊ
	for (size_t order = 0; order < m_pAkkhara->GetConversionOrdersNum(); order++) {
		for (size_t tableNo = 0; tableNo < m_pAkkhara->GetConversionNum(order); tableNo++) {
			CAkkharaConversionData convData = m_pAkkhara->GetConversion(order, tableNo);
			std::vector<std::wstring> beforeWords = convData.GetBeforeWords();

			// pґI̃tO-1̐ݒ͕̎ϊsȂ
			if (convData.GetUseFlag() == -1) {
				continue;
			}

			// ͕񂪕ϊ̒Zꍇ͏sȂ
			if (m_vwCharCodeInternal.size() < beforeWords.size()) {
				continue;
			}

			// ϊΏۂɈv邩`FbN
			int nExistCodeNum = 0;
			for (size_t before = 0; before < beforeWords.size(); before++) {
				if (beforeWords[before] == m_vwCharCodeInternal[(m_vwCharCodeInternal.size() - 1) - (beforeWords.size() - 1) + before]) {
					nExistCodeNum++;
				}
			}

			// ϊΏۂɈvꍇ͕ϊs
			if (nExistCodeNum == beforeWords.size()) {
				for (size_t before = 0; before < beforeWords.size(); before++) {
					m_wstrConvWords.pop_back();
					m_vwCharCodeInternal.pop_back();
				}
				std::vector<std::wstring> afterWords = convData.GetAfterWords();
				for (size_t after = 0; after < afterWords.size(); after++) {
					// eLXgo
					m_wstrConvWords += afterWords[after];
					m_vwCharCodeInternal.push_back(afterWords[after]);
				}
				// 폜pɓ͗ێ
				akkharaInputHistory.SetBeforeCharCodes(beforeWords);
				akkharaInputHistory.SetAfterCharCodes(afterWords);
			}
		}
	}

	// 폜pɓ͗zɕێ
	m_vakkharaInputHistory.push_back(akkharaInputHistory);
	for (size_t i = 0; i < m_vakkharaInputHistory.size(); i++) {
		m_vakkharaInputHistory[i].DebugLog();
	}

	LogOutputCode(__FUNCTION__, __LINE__, "m_wstrConvWords", m_wstrConvWords);

	return m_wstrConvWords;
}

// ̐K
std::wstring CAkkharaComposition::Normalization()
{
	LogOutputCode(__FUNCTION__, __LINE__, "Normalize In", m_wstrConvWords);
	// K
	for (size_t cnt = 0; cnt < m_pAkkhara->GetNormalizationNum(); cnt++) {
		CAkkharaConversionData convData = m_pAkkhara->GetNormalization(cnt);
		std::vector<std::wstring> beforeWords = convData.GetBeforeWords();
		std::vector<std::wstring> afterWords = convData.GetAfterWords();
		std::vector<std::wstring> vwNomal;
		std::wstring wstrNomal = L"";

		// KΏە񂪕ϊΏە̒Zꍇ͏sȂ
		if (m_vwCharCodeInternal.size() < beforeWords.size()) {
			continue;
		}

		// KΏۂɈv邩`FbN
		int exist = 0;
		for (size_t pos = 0; pos < m_vwCharCodeInternal.size(); pos++) {
			vwNomal.push_back(m_vwCharCodeInternal[pos]);
			wstrNomal += m_wstrConvWords[pos];
			if (m_vwCharCodeInternal[pos] == beforeWords[exist % beforeWords.size()]) {
				exist++;
			}
			else {
				exist = 0;
			}

			// KΏۂɈvꍇ͐KΏۏs
			if (exist == beforeWords.size()) {
				for (size_t before = 0; before < beforeWords.size(); before++) {
					//LogOutputCode(__FUNCTION__, __LINE__, "Normalize Proc", beforeWords[before]);
					wstrNomal.pop_back();
					vwNomal.pop_back();
				}
				for (size_t after = 0; after < afterWords.size(); after++) {
					wstrNomal += afterWords[after];
					vwNomal.push_back(afterWords[after]);
					//LogOutputCode(__FUNCTION__, __LINE__, "Normalize Proc", afterWords[after]);
				}
				exist = 0;
			}
		}
		m_wstrConvWords = wstrNomal;
		m_vwCharCodeInternal.clear();
		m_vwCharCodeInternal = vwNomal;
	}
	LogOutputCode(__FUNCTION__, __LINE__, "Normalize Out", m_wstrConvWords);
	return m_wstrConvWords;
}

// ͕Aϊ폜
void CAkkharaComposition::Delete(std::wstring& input, std::wstring& word)
{
	// ͕폜
	if (m_strKeyInput.size() > 0)
	{
		LogOutputCode(__FUNCTION__, __LINE__, "before m_strKeyInput", m_strKeyInput);
		m_strKeyInput.pop_back();
		LogOutputCode(__FUNCTION__, __LINE__, "after m_strKeyInput", m_strKeyInput);
	}
	input = StringToWString(m_strKeyInput);

	// ϊ폜
	if (m_wstrConvWords.size() > 0)
	{
		LogOutputCode(__FUNCTION__, __LINE__, "before m_wstrConvWords", m_wstrConvWords);
		CAkkharaInputHistory akkharaInputHistory = m_vakkharaInputHistory[m_vakkharaInputHistory.size() - 1];
		std::vector<std::wstring> vwstrCharCode = akkharaInputHistory.GetCharCode();
		std::vector<std::wstring> vwBeforeCharCodes = akkharaInputHistory.GetBeforeCharCodes();
		std::vector<std::wstring> vwAfterCharCodes = akkharaInputHistory.GetAfterCharCodes();
		for (size_t i = 0; i < vwAfterCharCodes.size(); i++) {
			m_wstrConvWords.pop_back();
			m_vwCharCodeInternal.pop_back();
		}
//		LogOutputCode(__FUNCTION__, __LINE__, "step 1 m_wstrConvWords", m_wstrConvWords);
		for (size_t i = 0; i < vwBeforeCharCodes.size(); i++) {
			m_wstrConvWords += vwBeforeCharCodes[i];
			m_vwCharCodeInternal.push_back(vwBeforeCharCodes[i]);
		}
//		LogOutputCode(__FUNCTION__, __LINE__, "step 2 m_wstrConvWords", m_wstrConvWords);
		for (size_t i = 0; i < vwstrCharCode.size(); i++) {
			m_wstrConvWords.pop_back();
			m_vwCharCodeInternal.pop_back();
		}
//		LogOutputCode(__FUNCTION__, __LINE__, "step 3 m_wstrConvWords", m_wstrConvWords);
		m_vakkharaInputHistory.pop_back();
		LogOutputCode(__FUNCTION__, __LINE__, "after m_wstrConvWords", m_wstrConvWords);
	}
	word = m_wstrConvWords;
}
