#pragma once

#include "Message.h"
#include <memory>
#include <minwindef.h>
#include <WinUser.h>

namespace Event {
	class AkkharaActivateEvent : public Event {
	public:
		AkkharaActivateEvent(){}

		virtual std::string GetName() {
			return Name();
		}

		static std::string Name() {
			return "AkkharaActivateEvent";
		}
	};

	class AkkharaActivateMessage: public Message
	{
	public:
		AkkharaActivateMessage(LPVOID parent, WNDPROC wndProc, HINSTANCE hInstance): parent_(parent), wndProc_(wndProc), hInstance_(hInstance) {}

		virtual std::shared_ptr<Event> EventType() {
			return std::shared_ptr<Event>(new AkkharaActivateEvent());
		}

		LPVOID Parent() { return parent_; }
		WNDPROC WndProc() { return wndProc_; }
		HINSTANCE HInstance() { return hInstance_; }

	private:
		LPVOID parent_; 
		WNDPROC wndProc_;
		HINSTANCE hInstance_;
	};
}

